#!/bin/bash

export PSMILE_SRC_DIR=$SVAROOT/oasis3/lib/psmile/src
export OAS_MAKEFILE_DIR=$SVAROOT/oasis3/util/make_dir

##################################################
# OASIS3-MCT: modification for adopting PDAF
##################################################

# mod_oasis_data.F90:
# iso_c_binding
sed "/USE mod_oasis_kinds.*/a  \  use,intrinsic :: iso_c_binding" -i $PSMILE_SRC_DIR/mod_oasis_data.F90
# new communicator
sed "/allocatable :: mpi_root_global/ a\\
  ! PDAF: New communicator \\
  integer(c_int),bind(C,name=\"fsubcomm\") :: da_comm \\
  ! PDAF: OASIS prefix number \\
  integer(c_int),bind(C,name=\"oasprefixno\") :: oasprefixno
" -i $PSMILE_SRC_DIR/mod_oasis_data.F90

# mod_oasis_method.F90
# new communicator
sed "116a\\
#ifdef use_comm_da \\
  write(*,*) 'OASIS: Using communicator from PDAF' \\
  mpi_comm_global = da_comm \\
#endif" \
-i $PSMILE_SRC_DIR/mod_oasis_method.F90
# prefix for output / debug files
sed "s/(a,i6.6)') 'nout.'/(a,i5.5,a,i6.6)') 'oas.',oasprefixno,'.nout.'/" -i $PSMILE_SRC_DIR/mod_oasis_method.F90
sed "s/'(a,i2.2)') 'debug.root.'/'(a,i5.5,a,i2.2)') 'oas.',oasprefixno,'.debug.root.'/" -i $PSMILE_SRC_DIR/mod_oasis_method.F90
sed "s/'(a,i2.2)') 'debug_notroot.'/'(a,i5.5,a,i2.2)') 'oas.',oasprefixno,'.debug_notroot.'/" -i $PSMILE_SRC_DIR/mod_oasis_method.F90
sed "s/'(a,i2.2,a,i6.6)') 'debug.',compid,'.',mpi_rank_local/'(a,i5.5,a,i2.2,a,i6.6)') 'oas.',oasprefixno,'.debug.',compid,'.',mpi_rank_local/" -i $PSMILE_SRC_DIR/mod_oasis_method.F90
# replace MPI_COMM_WORLD
sed "s/MPI_COMM_WORLD/da_comm/" -i $PSMILE_SRC_DIR/mod_oasis_method.F90
sed "s/oas_oas/oas/" -i $PSMILE_SRC_DIR/mod_oasis_method.F90

echo "CPPDEF += -Duse_comm_da" >> $OAS_MAKEFILE_DIR/make.inc

