#!/bin/bash

# modify compiler setting
if [ "$HOST" != 'juqueen' ]; then
sed "s/setenv[ \t]*sva_compiler.*/setenv sva_compiler Gnu/" -i $BLD_TERR_DIR/build_oas3
sed "s/setenv LDSEQ_COS.*/setenv LDSEQ_COS gfortran/" -i $BLD_TERR_DIR/build_oas3
sed "s/.*setenv LIBGRIB1_COS.*//" -i $BLD_TERR_DIR/build_oas3
sed "/setenv SVAROOT/a \setenv LIBGRIB1_COS \$SVAROOT" -i $BLD_TERR_DIR/build_oas3

else
# modify default build option from 5 to 4, e.g., no COSMO
sed "s/\(set compile_option.*\)5/\14/g" -i $BLD_TERR_DIR/build_oas3
if [ $OPT_TERRSYSMP -eq 0 ]; then
sed "s/\(set compiler_optimization.*\)1/\10/g" -i $BLD_TERR_DIR/build_oas3
fi
if [ $CLEAN_TERRSYSMP -eq 0 ]; then
sed "s/\(set compile_clean.*\)1/\10/g" -i $BLD_TERR_DIR/build_oas3
fi
if [ $PROFILING -ne 0 ]; then
sed "s/\(set profiling.*\)0/\11/g" -i $BLD_TERR_DIR/build_oas3
fi
fi

# add use_da_comm compiler flag
export PSMILE_SRC_DIR=$SVAROOT/oasis3/lib/psmile/src

if [ "$COUPLE_TYPE" != parflow_stand_alone ]; then
sed "s/\(setenv\s*CPPDEF1.*\)\"/\1 -Duse_comm_da\"/" -i $BLD_TERR_DIR/build_oas3 
sed "s/\(WF.*\)\(-Duse_comm_da\)/\1-WF,\2/p" -i $BLD_TERR_DIR/build_oas3 
else
sed "s/with-amps=mpi1/with-amps=da/" -i $BLD_TERR_DIR/build_oas3
fi

# move libs to PDAF dir
if [ "$HOST" != 'juqueen' ]; then
  if [ "$COUPLE_TYPE" = parflow_stand_alone ]; then
  sed "/exit\s*0/ i\
  echo \"Copy model libraries\"\\
  \\
  cd \$PARFLOW_DIR\/pfsimulator\/lib\\
  cp libamps.a libamps_common.a libkinsol.a libparflow.a $PDAF_LIBS_DIR
  " -i $BLD_TERR_DIR/build_oas3
  elif [ "$COUPLE_TYPE" = clm_stand_alone ]; then
  sed "/exit\s*0/ i\
  echo \"Copy model libraries\"\\
  cd \$blddir_clm\\
  ar rc libclm.a \*.o\\
  cp libclm.a $PDAF_LIBS_DIR\\
  " -i $BLD_TERR_DIR/build_oas3
  else
  sed "/exit\s*0/ i\
  echo \"Copy model libraries\"\\
  cd \$blddir_oas\/Gnu\/lib\\
  cp \*.a $PDAF_LIBS_DIR\\
  \\
  cd \$blddir_clm\\
  ar rc libclm.a \*.o\\
  cp libclm.a $PDAF_LIBS_DIR\\
  \\
  cd \$PARFLOW_DIR\/lib\\
  cp libamps.a libamps_common.a libkinsol.a libparflow.a $PDAF_LIBS_DIR
  " -i $BLD_TERR_DIR/build_oas3
  fi
else
  if [ "$COUPLE_TYPE" = parflow_stand_alone ]; then
  sed "/exit\s*0/ i\
  echo \"Copy model libraries\"\\
  \\
  cd \$PARFLOW_DIR\/pfsimulator\/lib\\
  cp libamps.a libamps_common.a libkinsol.a libparflow.a $PDAF_LIBS_DIR
  " -i $BLD_TERR_DIR/build_oas3
  elif [ "$COUPLE_TYPE" = clm_stand_alone ]; then
  sed "/exit\s*0/ i\
  echo \"Copy model libraries\"\\
  cd \$blddir_clm\\
  ar rc libclm.a \*.o\\
  cp libclm.a $PDAF_LIBS_DIR\\
  " -i $BLD_TERR_DIR/build_oas3
  else
  sed "/exit\s*0/ i\
  echo \"Copy model libraries\"\\
  cd \$blddir_oas\/Ibm\/lib\\
  cp \*.a $PDAF_LIBS_DIR\\
  \\
  cd \$blddir_clm\\
  ar rc libclm.a \*.o\\
  cp libclm.a $PDAF_LIBS_DIR\\
  \\
  cd \$PARFLOW_DIR\/lib\\
  cp libamps.a libamps_common.a libkinsol.a libparflow.a $PDAF_LIBS_DIR
  " -i $BLD_TERR_DIR/build_oas3
  fi
fi
