#!/bin/bash

########################## user setup ##########################
export COUPLE_TYPE=parflow_stand_alone
export SVAROOT=$HOME/terrsysmp-pdaf
export HOST=ibg3
export OPT_TERRSYSMP=1
export CLEAN_TERRSYSMP=1
export PROFILING=0
################################################################

export BLD_TERR_DIR=$SVAROOT/bldsva
export PDAF_TERRSYSMP_DIR=$SVAROOT/tsmp-pdaf
export PDAF_INSTALL_DIR=$PDAF_TERRSYSMP_DIR/install
export PDAF_LIBS_DIR=$PDAF_TERRSYSMP_DIR/libs
export PDAF_SRC_FRAMEWORK=$PDAF_TERRSYSMP_DIR/src/framework
export PDAF_SRC_MODEL=$PDAF_TERRSYSMP_DIR/src/model

cd $PDAF_INSTALL_DIR
echo "##################################################"
echo "Patching build_oas for PDAF"
echo "##################################################"
echo ""
./modify_build_oas3.sh || { echo "Failed" ; exit 1 ; }
echo "##################################################"
echo "Succeeded!"
echo "##################################################"
echo ""

if [ "$COUPLE_TYPE" == terrsysmp ]; then
echo "##################################################"
echo "Patching OASIS-MCT source files for PDAF"
echo "##################################################"
echo ""
./modify_oas_src.sh  || { echo "Failed" ; exit 1 ; }
echo "##################################################"
echo "Succeeded!"
echo "##################################################"
echo ""
fi

if [ "$COUPLE_TYPE" != clm_stand_alone ]; then
echo "##################################################"
echo "Patching PARFLOW source files for PDAF"
echo "##################################################"
echo ""
./modify_pfl_src.sh  || { echo "Failed" ; exit 1 ; }
echo "##################################################"
echo "Succeeded!"
echo "##################################################"
echo ""
fi

if [ "$COUPLE_TYPE" == clm_stand_alone ];then
echo "##################################################"
echo "Patching CLM source files for PDAF"
echo "#################################################"
./modify_clm_src.sh || { echo "Failed" ; exit 1; }
echo "##################################################"
echo "Succeeded!"
echo "##################################################"
echo ""
fi


if [ ! -d $PDAF_LIBS_DIR ]; then mkdir -p $PDAF_LIBS_DIR; fi
rm -fr $PDAF_LIBS_DIR/*


