#!/bin/bash

################## USER DEFINE SECTION #########################
export COUPLE_TYPE=terrsysmp
export PDAF_DIR=$HOME/terrsysmp_pdaf/PDAF-D_V1.10
export EXE_NAME=tsmp-pdaf-pfclm

PROFILING=false
DEBUG=false
CLEAN_BUILD=true
################################################################

if [ "$PROFILING" = true ]; then
export PREP_C="scalasca -instrument"
fi
export PDAF_TERRSYSMP_DIR=`pwd`/..
export PDAF_SRC_FRAMEWORK=$PDAF_TERRSYSMP_DIR/src/framework
export PDAF_SRC_MODEL=$PDAF_TERRSYSMP_DIR/src/model


function build_model {
cd $PDAF_SRC_MODEL
if [ "$CLEAN_BUILD" = true ] ; then make clean ; fi
if [ "$DEBUG" = true ] ; then
make debug=on
else
make
fi
}

function build_framework {
cd $PDAF_SRC_FRAMEWORK
if [ "$CLEAN_BUILD" = true ] ; then make clean ; fi
if [ "$DEBUG" = true ] ; then
make debug=on
else
make
fi
}

build_model && build_framework
echo "End building"
