#!/bin/bash
#
# arguments: 1 - compliation mode (production (default), debug)
#            2 - clean before reocmpilation (clean (default), noclean)
#            3 - iron switch (iron (default), noiron)

# Fill in appropriate paths:
ERSEMROOT=PATH_TO_ERSEM_ROOT
NETCDFINCDIR=PATH_TO_NETCDF_INCLUDE
NETCDFLIBDIR=PATH_TO_NETCDF_LIBRARY

ERSEMSRCDIR=$ERSEMROOT/src
AQUARIUMSRCDIR=$ERSEMROOT/drivers/ersem_aquarium

# Run directory
RUNDIR=`pwd`

# Fortran compiler
FORTRAN_COMPILER=GFORTRAN

# Netcdf output
HDFLIBDIR=$NETCDFLIBDIR
ZLIBDIR=$NETCDFLIBDIR

# Configuration options - debug/production (default)/profiling.
COMPILATION_MODE=${1:-"production"}

# Configuration options - clear
CLEAN="yes"
if [ ${2:-"clean"} = "noclean" ] ; then
    ${CLEAN}="no"
fi

# Configuration options - masstracer & restart
MASSTRACER=y
RESTART=y
CALC=y
SAVEFLX=y
DOCDYN=y
IOP=y

# For budgets and logging
cp ncdfErsem?D.list $ERSEMSRCDIR/output/

# Clean
cd $AQUARIUMSRCDIR
if [ "${CLEAN}" = "yes" ]; then
    gmake realclean ERSEMROOT=$ERSEMROOT ERSEMSRCDIR=$ERSEMSRCDIR FORTRAN_COMPILER=$FORTRAN_COMPILER
    echo "Cleaned ersem-aquarium source tree ready for recompilation."
fi

# Build
gmake ersem_aquarium COMPILATION_MODE=${COMPILATION_MODE} IOPMODEL=${IOP} DOCDYN=${DOCDYN} IRON=${IRON} MASSTRACER=${MASSTRACER} RESTART=${RESTART} CALC=${CALC} SAVEFLX=${SAVEFLX} ERSEMROOT=$ERSEMROOT ERSEMSRCDIR=$ERSEMSRCDIR FORTRAN_COMPILER=$FORTRAN_COMPILER NETCDFINCDIR=$NETCDFINCDIR NETCDFLIBDIR=$NETCDFLIBDIR HDFLIBDIR=$HDFLIBDIR ZLIBDIR=$ZLIBDIR

# Finish up
if [ -f ersem_aquarium ]; then
    mv ersem_aquarium ${RUNDIR}/
    echo "Done."
else
    echo "Error during ersem-aquarium compilation."
    exit 1
fi

