#!/bin/bash
#
# arguments: 1 - compliation mode
#            2 - clean before recompilation
#

#Fill in with appropriate paths:
GOTMDIR=PATH_TO_GOTM_ROOT
ERSEMDIR=PATH_TO_ERSEM_ROOT
NETCDFINC=PATH_TO_NETCDF_INCLUDE_FILES
NETCDFLIBDIR=PATH_TO_NETCDF_LIBRARY_FILES

ERSEMSRC=$ERSEMDIR/src
HDFLIBDIR=$NETCDFLIBDIR
ZLIBDIR=$NETCDFLIBDIR
GOTMERSEMDIR=$ERSEMDIR/drivers/ersem_gotm
COMPILER=GFORTRAN
rsync -a ncdfErsem3D.docdyn.list ncdfErsem3D.list
cp ncdfErsem?D.list $ERSEMSRC/output/
rm -f gotmersem
RUNDIR=`pwd`

# Clean up for recompilation
if [ ${2:-"clean"} = "clean" ] ; then
    # Gotm clean
    cd $GOTMDIR/src
    gmake realclean IRON=y IOPMODEL=y DOCDYN=y SAVEFLX=y RESTART=y ERSEMPATH=$ERSEMDIR GOTMERSEMPATH=$GOTMERSEMDIR MASSTRACER=y CALC=y COMPILATION_MODE=${1:-"production"} GOTMDIR=$GOTMDIR FORTRAN_COMPILER=$COMPILER NETCDFINCDIR=$NETCDFINC NETCDFLIBDIR=$NETCDFLIBDIR HDFLIBDIR=$HDFLIBDIR ZLIBDIR=$ZLIBDIR

    # Gotm-ersem clean
    cd $GOTMERSEMDIR/
    gmake realclean FORTRAN_COMPILER=$COMPILER ERSEMROOT=$ERSEMDIR
fi

# Compilation
cd $GOTMDIR/src
gmake gotmersem IRON=y IOPMODEL=y DOCDYN=y SAVEFLX=y RESTART=y ERSEMPATH=$ERSEMDIR GOTMERSEMPATH=$GOTMERSEMDIR MASSTRACER=y CALC=y COMPILATION_MODE=${1:-"production"}  GOTMDIR=$GOTMDIR FORTRAN_COMPILER=$COMPILER NETCDFINCDIR=$NETCDFINC NETCDFLIBDIR=$NETCDFLIBDIR HDFLIBDIR=$HDFLIBDIR ZLIBDIR=$ZLIBDIR

# The gotmersem executable
mv gotmersem $RUNDIR/gotmersem

