input_file = '/home/h01/hadax/Fortran/1D_multilayers/Parallel/TATMOS_stability_blitz/run_ice_stability.namelist'
result_file = '/data/local/hadax/Multilayers/Parallel/Thin_ice_sb/result.txt'
ice_data_file = '/data/local/hadax/Multilayers/Parallel/Thin_ice_sb/data_ice1.dat'
datadir = '/data/local/hadax/Multilayers/Parallel/Thin_ice_sb/'

import numpy as np
import subprocess
import os
import matplotlib.pyplot as plt
import matplotlib.cm as mpl_cm
import pickle

wind_values = np.arange(500.)/10.
ice_values = 10**((np.arange(900.)-800.)/200.)

success_logical = np.zeros([500,900],dtype='bool_')
convergence_cp = np.zeros([500,900],dtype='float64')
oscillate_logical = np.zeros([500,900],dtype='bool_')

missing_data_value = 1.e20

for (wi,wv) in enumerate(wind_values):
    for (ii,iv) in enumerate(ice_values):
    
        print('Setting up and running model for wind speed = %f8.4, ice thickness = %f8.4' % (wv,iv) )
	
        fileh = open(input_file,'w')
	fileh.write('&parameters\n')
	fileh.write('wind_speed = %f\n' % wv)
	fileh.write('ice_thickness = %f\n' % iv)
	fileh.write('/\n')
	fileh.close()

        os.system('a.out')

        fileh_r = open(result_file,'r')
	result = int(fileh_r.read()[0:1])
	fileh_r.close()
	success_logical[wi,ii] = (result==1)
	
	if (result==1):
            fileh = open(ice_data_file,'r')

	    T1_array = []
            for line in fileh.readlines():
		tlt = float(line[56:70])
		T1_array.append(tlt)

	    T1_array = np.array(T1_array)
            final_value = T1_array[-1]
	    fv_diff = T1_array - final_value

            index_3hr = range(24,36,3)
            index_1hr = range(24,36,1)
            fv_diff_sample3 = fv_diff[index_3hr]
            fv_diff_sample1 = fv_diff[index_1hr]
            oscillates = np.sign(fv_diff_sample3[0]) != np.sign(fv_diff_sample3[1])
	    ratio = np.mean(np.abs(fv_diff_sample3[0:3] / fv_diff_sample3[1:4]))
	    
	    if np.isnan(ratio):
	        ratio = missing_data_value

            oscillate_logical[wi,ii] = oscillates
	    convergence_cp[wi,ii] = ratio
	

brewer_cmap = mpl_cm.get_cmap('brewer_Oranges_09')

levels = np.arange(0.,1.1,0.1)
colours = ['#5080ff','#8080ff','#a580ff','#ca80ff','#ff80ff','#ff80ca','#ff80a5','#ff8080','#ff8050','#ff8020']

plt.figure(figsize=(10,6))
plt.contour(ice_values,wind_values,oscillate_logical,[.5],colors=('#000000',),linewidths=(3,))
plt.contour(ice_values,wind_values,success_logical,[.5],colors=('#000000',),linewidths=(3,))
cs = plt.contourf(ice_values,wind_values,1./convergence_cp,levels,colors=colours)
plt.xlabel('Ice thickness (m)')
plt.ylabel('Wind speed (m/s)')
plt.xlim([0,1])
plt.ylim([0,100])
plt.text(0.7,20,'Monotonic\nconvergence',ha='center')
plt.text(0.13,44,'Instability',ha='center')
cb = plt.colorbar(cs)
cb.set_label('Approximate 3-hour rate of convergence')
plt.show()

pickle.dump(oscillate_logical,open(datadir+'oscillate_logical_mix1_um.pck1','w'))
pickle.dump(success_logical,open(datadir+'success_logical_mix1_um.pck1','w'))
pickle.dump(convergence_cp,open(datadir+'convergence_cp_mix1_um.pck1','w'))
