import pickle
import matplotlib.pyplot as plt
import matplotlib.cm as mpl_cm
import numpy as np
import os
import mlplot

wind_values = np.arange(500.)/10.
ice_values = 10**((np.arange(900.)-800.)/200.)

datadir = '/data/local/hadax/Multilayers/Parallel/Thin_ice_sb/'
success_logical = pickle.load(open(datadir+'success_logical_mix_um.pck1'))
oscillate_logical = pickle.load(open(datadir+'oscillate_logical_mix_um.pck1'))
convergence_3hr = pickle.load(open(datadir+'convergence_cp_mix_um.pck1'))

brewer_cmap = mpl_cm.get_cmap('brewer_Oranges_09')

levels = np.arange(0.,1.1,0.1)
colours = ['#5080ff','#8080ff','#a580ff','#ca80ff','#ff80ff','#ff80ca','#ff80a5','#ff8080','#ff8050','#ff8020']

plt.figure(figsize=(12,6))
plt.contour(ice_values,wind_values,oscillate_logical,[.5],colors=('#000000',),linewidths=(3,))
ax = plt.gca()
ax.set_position([.28,.08,.5,.8])
plt.contour(ice_values,wind_values,success_logical,[.5],colors=('#000000',),linewidths=(3,))
cs = plt.contourf(ice_values,wind_values,1./convergence_3hr,levels,colors=colours)
plt.xlabel('Ice thickness (m)')
plt.ylabel('Wind speed (m/s)')
plt.xlim([0,1])
plt.ylim([0,50])
plt.text(0.7,20,'Monotonic\nconvergence',ha='center')
plt.text(0.09,38,'Oscillating\nconvergence',ha='center',rotation=58)
#plt.text(0.14,45,'Instability',ha='center')
cb = plt.colorbar(cs)
cb.set_label('Approximate 3-hour rate of convergence')

fig = plt.gcf()

ypts = (-20,0)

wv = 40
iv = .01
lpos = wv / 50.
hpos = iv / 1.
position = [.07,.83,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)

wv = 40
iv = .04
hpos = wv / 50.
lpos = iv / 1.
position = [.07,.64,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)


wv = 23
iv = .1
hpos = wv / 50.
lpos = iv / 1.
position = [.07,.45,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)
ax.set_ylabel('Top layer temperature (deg C)')

wv = 15
iv = .1
hpos = wv / 50.
lpos = iv / 1.
position = [.07,.26,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)

wv = 5
iv = .1
hpos = wv / 50.
lpos = iv / 1.
position = [.07,.07,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)
ax.set_xlabel('Days')

wv = 40
iv = .8
lpos = wv / 50.
hpos = iv / 1.
position = [.85,.83,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)

wv = 40
iv = .4
hpos = wv / 50.
lpos = iv / 1.
position = [.85,.64,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)


wv = 40
iv = .25
hpos = wv / 50.
lpos = iv / 1.
position = [.85,.45,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)
ax.set_ylabel('Top layer temperature (deg C)')

wv = 5
iv = .8
hpos = wv / 50.
lpos = iv / 1.
position = [.85,.26,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)

wv = 5
iv = .2
hpos = wv / 50.
lpos = iv / 1.
position = [.85,.07,.14,.14]
thumbnail = fig.add_axes(position)
mlplot.demonstrate(wv, iv,ypts=ypts)
ax = plt.gca()
ax.set_ylim(ypts)
ax.set_xlabel('Days')

plt.show()
