FUNCTION ml1_read, filename, nskip=nskip, nrecs=nrecs, debug=debug, $
  atmos=atmos, iceonly=iceonly, nvars = nvars

if not keyword_set(nskip) then nskip=0

if keyword_set(atmos) then begin
  format = '(5(E13.6,1X))'
endif else if keyword_set(iceonly) then begin
  format = '(10(E13.6,1X))'
endif else begin
  format = '(8(E13.6,1X))'
endelse

nrecs=file_lines(filename)-nskip

array=fltarr(nvars,nrecs)
r=DC_read_fixed(filename,array,/column,nskip=nskip,format=format)

if keyword_set(debug) then stop
return, transpose(array)
END
