PRO ml1_plot, str1, str2, str3, str4, str5, str6, varno = varno, $
  window = window, colours = colours, linestyles = linestyles, $
  psyms = psyms, overplot = overplot, YRange = YRange, thicks = thicks, $
  YTitle = YTitle, YStyle = YStyle, position = position, $
  no_xlegend = no_xlegend, xl_yprops = xl_yprops, YTickInterval = YTickInterval, $
  YMinor = YMinor, title = title, XTitle = XTitle, cpl3 = cpl3
  
l_str = [n_elements(str1) GT 0,n_elements(str2) GT 0,n_elements(str3) GT 0,$
         n_elements(str4) GT 0,n_elements(str5) GT 0,n_elements(str6) GT 0]
n_str = sum(l_str)


if not keyword_set(colours) then colours = $
  replicate_cyclic([0,'FF0000'x,'0040A0'x,'808080'x,$
  'FF00FF'x,'3050FF'x],n_str)
if not keyword_set(linestyles) then linestyles = replicate(!P.Linestyle,n_str)
if not keyword_set(psyms) then psyms = replicate(!P.PSym,n_str)
if not keyword_set(thicks) then thicks = replicate(!P.Thick,n_str)

if not keyword_set(overplot) then begin
  ; Decide on a YRange
  for expt = 0,n_str-1 do begin
    command = 'pts = str'+nicenumber(expt+1)+'[*,varno].DATA'
    r = execute(command)
    command = 'ntims = str'+nicenumber(expt+1)+'[*,varno].NTIM'
    r = execute(command)
    if r then begin
      pts = pts[where(ntims GE window[0] AND ntims LE window[1])]
      if expt EQ 0 then all_pts = pts else all_pts =[all_pts,pts]
    endif else begin
      message, 'Command not successfully executed.'
    endelse
  endfor

  mindata = min(all_pts)
  maxdata = max(all_pts)
  rdata = maxdata - mindata
  YR = mindata + rdata * 1.2 * [-.1,1.1]
  if not keyword_set(YRange) then YRange = YR

  if not keyword_set(YStyle) then YStyle = 1
  plot, [0], [0], /nodata, XRange = window, XStyle = 1, YRange = YRange, $
    XTickLen = .00001, XTickName = replicate(' ',12), YStyle = YStyle, $
    YTitle = YTitle, position = position, YTickInterval = YTickInterval, $
    YMinor = YMinor, title = title, XTitle = XTitle 

  ; Draw x-legend
  
  tick_orientation = -90.

  if not keyword_set(xl_yprops) then begin
    major_tick_yprop = .04
    medium_tick_yprop = .02
    minor_tick_yprop = .01
  endif else begin
    major_tick_yprop = xl_yprops[0]
    medium_tick_yprop = xl_yprops[1]
    minor_tick_yprop = xl_yprops[2]
  endelse

  wlen = window[1] - window[0]
  case 1 of
    wlen LT 1.e4: begin
      mtick = 1
      htick = 1
      dtick = 0
    end
    wlen GE 1.e4 AND wlen LT 3.e5: begin
      mtick = 0
      htick = 1
      dtick = 1
    end
    wlen GE 3.e5: begin
      mtick = 0
      htick = 0
      dtick = 1
    end
  endcase

  if htick then begin
    hfirst = floor(window[0]/3600.)
    hlast  = ceil(window[1]/3600.)

    for hour = hfirst,hlast do begin
      case 1 of
	dtick AND (hour mod 3 EQ 0): yprop = major_tick_yprop
	dtick AND (hour mod 3 NE 0): yprop = medium_tick_yprop
	(NOT dtick) AND (hour mod 3 EQ 0): yprop = medium_tick_yprop
	(NOT dtick) AND (hour mod 3 NE 0): yprop = minor_tick_yprop
      endcase

      ytick = YRange[0] + [0,-1] * (YRange[1] - YRange[0]) * yprop
      xhour = hour * 3600.
      xtick = xhour + [0,1] * yprop * wlen / tan(tick_orientation*!pi/180.)

      if not keyword_set(no_xlegend) then begin
	oplot, xtick, ytick, /noclip
        hourday = hour mod 24
	if hour mod 3 EQ 0 then $
	  XYOuts, xhour, YRange[0] - yprop * (YRange[1] - YRange[0]) * 2., $
            nicenumber(hourday), alignment = .5, charsize = !P.Charsize/2.
      endif

      oplot, [xhour,xhour], YRange, color = 'E8E8E8'x
      oplot, [xhour,xhour]+.333*3600., YRange, color = 'E8E8E8'x, linestyle = 1
      oplot, [xhour,xhour]+.667*3600., YRange, color = 'E8E8E8'x, linestyle = 1

      cplmod = 1 + 2*(keyword_set(cpl3))

      if hour mod cplmod EQ 0 then oplot, [xhour,xhour], YRange, color = 'C0C0C0'x


    endfor
  endif
end
  
for expt = 0,n_str-1 do begin
  command = 'pstr = str'+nicenumber(expt+1)
  r = execute(command)
  if r then begin
    xplot = pstr[*,varno].NTIM
    yplot = pstr[*,varno].DATA
    oplot, xplot, yplot, linestyle = linestyles[expt], color = colours[expt], $
      psym = psyms[expt], thick = thicks[expt]
  endif else begin
    message, 'Command not successfully executed.'
  endelse
endfor
END
