!=======================================================================
!BOP
!
! !MODULE: ice_domain_size
!
! !DESCRIPTION:
!
! Defines the global domain size and number of categories and layers.
! Code originally based on domain_size.F in POP
!
! !REVISION HISTORY:
!  SVN:$Id: ice_domain_size.F90 206 2009-08-05 15:10:39Z eclare $
!
! author Elizabeth C. Hunke, LANL
! 2004: Block structure and snow parameters added by William Lipscomb
!       Renamed (used to be ice_model_size)
! 2006: Converted to free source form (F90) by Elizabeth Hunke
!       Removed hardwired sizes (NX...can now be set in compile scripts)
!
! !INTERFACE:
!
      module ice_domain_size
!
! !USES:
!
      use ice_kinds_mod
!
!EOP
!=======================================================================

      implicit none
      save

      integer (kind=int_kind), parameter :: &
        nx_global = 1         , & ! i-axis size
        ny_global = 1         , & ! j-axis size
        ncat      = 1         , & ! number of categories
        max_ntrcr =   1       , & ! number of tracers (defined in ice_init)
                                  ! 1 = surface temperature
        max_nstrm =   1           ! max number of history output streams

! These are set in the namelist
      integer (kind=int_kind) :: &
        nilyr              , & ! number of ice layers per category
        nslyr                  ! number of snow layers per category

! These aren't set in the namelist, but they will need to be calculated
! after it's read...
      integer (kind=int_kind) :: &
        ntilyr,    & ! number of ice layers in all categories
        ntslyr       ! number of snow layers in all categories


      integer (kind=int_kind), parameter :: &
        block_size_x = 1  , & ! size of block in first horiz dimension
        block_size_y = 1      ! size of block in second horiz dimension

   !*** The model will inform the user of the correct
   !*** values for the parameter below.  A value higher than
   !*** necessary will not cause the code to fail, but will
   !*** allocate more memory than is necessary.  A value that
   !*** is too low will cause the code to exit.  
   !*** A good initial guess is found using
   !*** max_blocks = (nx_global/block_size_x)*(ny_global/block_size_y)/
   !***               num_procs
 
      integer (kind=int_kind), parameter :: &
        max_blocks = 1      ! max number of blocks per processor

!=======================================================================

      end module ice_domain_size

!=======================================================================
