; Plot out surface heat flux and top layer ice temperature for 
; - main 'parallel' experiment
; - original 'series' experiment
; - snow layer experiment
; - 20ms-1 wind experiment

dirnames = ['/data/local/hadax/Multilayers/Parallel/gamma.w5.0.std/',$
  '/data/local/hadax/Multilayers/Parallel/gamma.w5.0.snow/',$
  '/data/local/hadax/Multilayers/Parallel/gamma.w20.0.std/',$
  '/data/local/hadax/Multilayers/Parallel/beta.w5.0.std/']

savdirnames = ['/data/cr1/hadax/1D_Multilayers/gamma.w5.0.std/',$
  '/data/cr1/hadax/1D_Multilayers/gamma.w5.0.snow/',$
  '/data/cr1/hadax/1D_Multilayers/gamma.w20.0.std/',$
  '/data/cr1/hadax/1D_Multilayers/beta.w5.0.std/']

expt_titles = ['Control','11cm snow layer','20m/s wind speed','Models in parallel']
n_expts = n_elements(expt_titles)

snow = ['1cm','11cm','11cm','11cm']
ice = ['1cm','25cm','25cm','25cm']
atm_dt = ['1s','1s','20min','20min']
ice_dt = ['1s','1s','1h','1h']
cpl_dt = ['1s','1s','3h','3h']
cpl_method = ['cice','cice','cice','jules']
nset = n_elements(cpl_method)

dt = [1.,1.,3600.,3600.]
atmos_dt = [1.,1.,1200.,1200.]
min_print = [60,60,1,1]    ; Period of diagnostic output / timestep.

outfile = '/home/h01/hadax/graphics/1D_Multilayers/Paper/expt3_try.eps'
read_data = 0


if read_data then begin
   for expt_no = 0,n_expts-1 do begin
      for setno = 0,nset-1 do begin
         print, 'Reading in data for experiment '+expt_titles[expt_no]+', setting '+nicenumber(setno)

         if (expt_no EQ 5) then begin
            if (atm_dt[setno] EQ '20min') then begin
               atm_set_use = '20m'
            endif else begin
               atm_set_use = atm_dt[setno]
            endelse

            if (cpl_method[setno] EQ 'cice') then begin
               cpl_method_use = 'std'
            endif else begin
               cpl_method_use = 'um'
            endelse

            file_ice = dirnames[expt_no] + 'data_nobrine_at'+atm_set_use+'_it'+$
              ice_dt[setno]+'_cp'+cpl_dt[setno]+'_z'+ice[setno]+'_ice_'+$
              cpl_method_use+'.dat'

            file_atm = dirnames[expt_no] + 'data_nobrine_at'+atm_set_use+'_it'+$
              ice_dt[setno]+'_cp'+cpl_dt[setno]+'_z'+ice[setno]+'_atm_'+$
              cpl_method_use+'.dat'

         endif else begin
            
            file_ice = dirnames[expt_no] + 'icedata_snow_'+snow[setno]+'_ice_'+ice[setno]+$
              '_atmdt_'+atm_dt[setno]+'_icedt_'+ice_dt[setno]+'_cpldt_'+$
              cpl_dt[setno]+'_cplm_'+cpl_method[setno]+'.dat'
            
            file_atm = dirnames[expt_no] + 'atmdata_snow_'+snow[setno]+'_ice_'+ice[setno]+$
              '_atmdt_'+atm_dt[setno]+'_icedt_'+ice_dt[setno]+'_cpldt_'+$
              cpl_dt[setno]+'_cplm_'+cpl_method[setno]+'.dat'

         endelse

         nvars_ice = 12 - 2*(expt_no EQ 1)
         nvars_atm = 5
         array_ice = ml1_read(file_ice,nskip=0,nrecs=nrecs_ice,/iceonly,nvars=nvars_ice)
         array_atm = ml1_read(file_atm,nskip=0,nrecs=nrecs_atm,/atmos,nvars=nvars_atm)

         Interval_ice = dt[setno] * min_print[setno]
         Interval_atm = atmos_dt[setno] * min_print[setno]
         times_ice = Lindgen(nrecs_ice)*Interval_ice           ; first record is at 0.
         times_atm = (Lindgen(nrecs_atm)+1)*Interval_atm           ; first record is at 0.
    
         work_structure_ice = set_ml1(nrecs = nrecs_ice,nvars = nvars_ice)
         work_structure_atm = set_ml1(nrecs = nrecs_atm,nvars = nvars_atm)
         error_structure_ice = set_ml1(nrecs = nrecs_ice,nvars = nvars_ice)
         error_structure_atm = set_ml1(nrecs = nrecs_atm,nvars = nvars_atm)
         work_structure_atm[*,*].DATA = array_atm[*,*]
         work_structure_ice[*,*].DATA = array_ice[*,*]

         for var_no = 0,9 do begin
            work_structure_ice[*,var_no].NTIM = work_structure_ice[*,0].DATA
            error_structure_ice[*,var_no].NTIM = work_structure_ice[*,0].DATA
         endfor
         for var_no = 0,4 do begin
            work_structure_atm[*,var_no].NTIM = work_structure_atm[*,0].DATA
            error_structure_atm[*,var_no].NTIM = work_structure_atm[*,0].DATA
         endfor
    
         if setno EQ 0 then begin
            truth_structure_ice = work_structure_ice
            truth_structure_atm = work_structure_atm
         endif else begin
            for var_no = 0,9 do begin
               i1 = find(error_structure_ice[*,0].NTIM,truth_structure_ice[*,0].NTIM,which=i2)
	       error_structure_ice[i1,var_no].data = work_structure_ice[i1,var_no].data - truth_structure_ice[i2,var_no].data
            endfor
            for var_no = 0,4 do begin
               i1 = find(error_structure_atm[*,0].NTIM,truth_structure_atm[*,0].NTIM,which=i2)
	       error_structure_atm[i1,var_no].data = work_structure_atm[i1,var_no].data - truth_structure_atm[i2,var_no].data
            endfor
         endelse
    
         savdir = savdirnames[expt_no-1]
         varname='data_atm'+nicenumber(setno+1)+'_expt'+nicenumber(expt_no+1)
         r=execute(varname+'=work_structure_atm')
         savfile=savdir+'data_atm'+nicenumber(setno+1)+'.sav'
         r = execute('save, '+varname+', file=savfile')

         varname='data_ice'+nicenumber(setno+1)+'_expt'+nicenumber(expt_no+1)
         r=execute(varname+'=work_structure_ice')
         savfile=savdir+'data_ice'+nicenumber(setno+1)+'.sav'
         r = execute('save, '+varname+', file=savfile')

         varname='error_atm'+nicenumber(setno+1)+'_expt'+nicenumber(expt_no+1)
         r=execute(varname+'=error_structure_atm')
         savfile=savdir+'error_atm'+nicenumber(setno+1)+'.sav'
         r = execute('save, '+varname+', file=savfile')

         varname='error_ice'+nicenumber(setno+1)+'_expt'+nicenumber(expt_no+1)
         r=execute(varname+'=error_structure_ice')
         savfile=savdir+'error_ice'+nicenumber(setno+1)+'.sav'
         r = execute('save, '+varname+', file=savfile')

      endfor
   endfor
endif else begin
   for expt_no=0,n_expts-1 do begin
      for setno=0,nset-1 do begin
         savdir = savdirnames[expt_no]
         savfile=savdir+'data_ice'+nicenumber(setno+1)+'.sav'
         restore, savfile
         savfile=savdir+'data_atm'+nicenumber(setno+1)+'.sav'
         restore, savfile
    
         savfile=savdir+'error_ice'+nicenumber(setno+1)+'.sav'
         restore, savfile
         savfile=savdir+'error_atm'+nicenumber(setno+1)+'.sav'
         restore, savfile
      endfor
   endfor
endelse

xl = .17
xw = .34
xgap = .48

yt = .74
yw = .12
yew = .06
ygap = .23

xll = -1.58
ytl = -0.6
xsl = 1.34
ysl = .5

!P.Multi = [16,2,8] 
!P.Charsize = 1.7 
ww = [48,49]*3600.*24.
xl_yprops = [.14,.07,.04]
letters = ['(a)','(b)','(c)','(d)','(e)','(f)','(g)','(h)']

UM_color = 255
standard_color = 'FFA020'x

Pr, /EPS, /Color, /Portrait, file = outfile
reset, thick = 3
!P.Multi = [16,2,8] 
!P.Charsize = 1.7 

YRs_flux_abs = [[-30,20],[-30,20],[-60,40],[-30,20]]
YRs_flux_err = [[-20,20],[-20,20],[-50,50],[-20,20]]
YRs_temp_abs = [[-4.5,-3.5],[-5.8,-2.2],[-6,-3],[-4.5,-3.5]]
YRs_temp_err = [[-.39,.39],[-1.2,1.2],[-1.2,1.2],[-.39,.39]]

titles = ['Control','11cm!Csnow layer','Wind speed!C5->20m/s','Parellel!Ccoupling']
for expt_no = 0,n_expts-1 do begin
   for setno = 0,nset-1 do begin
      r = execute('data_atm'+nicenumber(setno+1)+' = data_atm'+nicenumber(setno+1)+$
            '_expt'+nicenumber(expt_no+1))
      r = execute('data_ice'+nicenumber(setno+1)+' = data_ice'+nicenumber(setno+1)+$
            '_expt'+nicenumber(expt_no+1))
      r = execute('error_atm'+nicenumber(setno+1)+' = error_atm'+nicenumber(setno+1)+$
            '_expt'+nicenumber(expt_no+1))
      r = execute('error_ice'+nicenumber(setno+1)+' = error_ice'+nicenumber(setno+1)+$
            '_expt'+nicenumber(expt_no+1))
   endfor

   varno = 2
   position = xl*[1,0,1,0] + yt*[0,1,0,1] + xw * [0,0,1,0] - yw * [0,1,0,0] - $
     ygap * (expt_no-1) * [0,1,0,1]
   ml1_plot, data_atm1, window = ww, varno = varno, position = position, $
     YTitle = 'Surface flux (W/m!U2!N)!C ', $
     YRange = YRs_flux_abs[*,expt_no], title = letters[expt_no*2], thicks = 15, linestyles = 2, $
     /no_xlegend, /cpl3
   ml1_plot, data_atm2, window = ww, varno = varno, /overplot
   ml1_plot, data_atm3, window = ww, varno = varno, /overplot, colours = standard_color
   ml1_plot, data_atm4, window = ww, varno = varno, /overplot, colours = UM_color
   XYouts, xl - 0.145, yt - ygap * (expt_no) + yw*1.1, titles[expt_no], $
     orientation = 90, /normal, alignment = .5

   position = xl*[1,0,1,0] + (yt-yw)*[0,1,0,1] + xw * [0,0,1,0] - yew * [0,1,0,0] - $
     ygap * (expt_no-1) * [0,1,0,1]
   ml1_plot, error_atm1, window = ww, varno = varno, position = position, $
     YTitle = 'Error wrt HRC', xl_yprops = xl_yprops  , YRange = YRs_flux_err[*,expt_no], $
     YTickInterval = 20, YMinor = 2, /cpl3
   ml1_plot, error_atm2, window = ww, varno = varno, /overplot
   ml1_plot, error_atm3, window = ww, varno = varno, /overplot, colours = standard_color
   ml1_plot, error_atm4, window = ww, varno = varno, /overplot, colours = UM_color


   varno = 7 - 2*(expt_no EQ 1)
   position = xl*[1,0,1,0] + yt*[0,1,0,1] + xw * [0,0,1,0] - yw * [0,1,0,0] - $
     ygap * (expt_no-1) * [0,1,0,1] + xgap * [1,0,1,0]
   ml1_plot, data_ice1, window = ww, varno = varno, position = position, $
     YTitle = 'Top layer temp (deg C)!C!C ', $
     YRange = YRs_temp_abs[*,expt_no], title = letters[expt_no*2+1], thicks = 15, linestyles = 2, $
     /no_xlegend, /cpl3
   ml1_plot, data_ice2, window = ww, varno = varno, /overplot
   ml1_plot, data_ice3, window = ww, varno = varno, /overplot, colours = standard_color
   ml1_plot, data_ice4, window = ww, varno = varno, /overplot, colours = UM_color

   position = xl*[1,0,1,0] + (yt-yw)*[0,1,0,1] + xw * [0,0,1,0] - yew * [0,1,0,0] - $
     ygap * (expt_no-1) * [0,1,0,1] + xgap * [1,0,1,0]
   ml1_plot, error_ice1, window = ww, varno = varno, position = position, $
     YTitle = 'Error wrt HRC', xl_yprops = xl_yprops  , YRange = YRs_temp_err[*,expt_no], $
     YTickInterval = .2+.3*(expt_no GE 1 and expt_no LE 2), YMinor = 2, /cpl3
   ml1_plot, error_ice2, window = ww, varno = varno, /overplot
   ml1_plot, error_ice3, window = ww, varno = varno, /overplot, colours = standard_color
   ml1_plot, error_ice4, window = ww, varno = varno, /overplot, colours = UM_color

endfor

xlength = .08
linekey_noconv, xll, ytl - ysl*0., $
  title = 'Hi-res control (''HRC'', dz = 1cm, dt = 1s)', $
  thick = 15, linestyle = 2, $
  xlength = xlength, charsize = lc 
linekey_noconv, xll, ytl - ysl*1., $
  title = '4-layer control (dz = 25cm, dt = 1s)', xlength = xlength, $
  charsize = lc 
linekey_noconv, xll + xsl*1., ytl - ysl*0., title = '''JULES'' coupling (dz = 25cm, ice dt = 1h,!Catmos dt = 20min, coupling dt = 3h)', $
  color = UM_color, xlength = xlength, charsize = lc
linekey_noconv, xll + xsl*1., ytl - ysl*1., title = '''CICE'' coupling (dz = 25cm, ice dt = 1h,!Catmos dt = 20min, coupling dt = 3h)', $
      color = standard_color, xlength = xlength, charsize = lc 
Prend, /keep, /noprint

END
