; Plot out variables for the second set of experiments in Alison's 1D solver.

datadiry = '/data/local/hadax/Multilayers/1D/'
savdir = '/data/cr1/hadax/1D_Multilayers/thin_ice/'
outfile1 = '~hadax/graphics/1D_Multilayers/Paper/expt2_try_cp_1h.eps'
outfile2 = '~hadax/graphics/1D_Multilayers/Paper/expt2_try_cp_3h.eps'

zset = ['1cm','25cm','25cm','25cm','25cm','25cm']
tatset = ['1s','1s','20m','20m','20m','20m']
ticset = ['1s','1s','1h','1h','1h','1h']
tcpset = ['1s','1s','1h','1h','3h','3h']
mset = ['std','std','std','um','std','um']

dt = [1.,1.,3600.,3600.,3600.,3600.]
atmos_dt = [1.,1.,1200.,1200.,1200.,1200.]
cpl_dt = [1.,1.,3600.,3600.,10800.,10800.]
min_print = [60,60,1,1,1,1]    ; Period of diagnostic output / timestep.
                               ; This is set to 60 for the high T-res expts
			       ; to save time reading in the data.

n_exps = n_elements(mset)
read_data = 0

filenames_ice = 'data_nobrine_at'+tatset+'_it'+ticset+'_cp'+tcpset+'_z'+zset+$
  '_ice_'+mset+'.dat'
filenames_atm = 'data_nobrine_at'+tatset+'_it'+ticset+'_cp'+tcpset+'_z'+zset+$
  '_atm_'+mset+'.dat'
files_ice = datadiry+filenames_ice
files_atm = datadiry+filenames_atm

if read_data then begin
  for expt_no = 0, n_exps-1 do begin
    print, 'Reading in data for experiment '+nicenumber(expt_no+1)
    array_ice = ml1_read(files_ice[expt_no],nskip=0,nrecs=nrecs_ice,/iceonly)
    array_atm = ml1_read(files_atm[expt_no],nskip=0,nrecs=nrecs_atm,/atmos)

    ; !!!!! There's a potential problem here if min_print > 1 and 
    ; atmos_dt < dt, in which case in the current setup the atmosphere
    ; diagnostics will be printed out at rather irregular intervals.
    ; Fortunately, in none of the current experiments do both of these
    ; conditions hold.
    Interval_ice = dt[expt_no] * min_print[expt_no]
    Interval_atm = atmos_dt[expt_no] * min_print[expt_no]
    times_ice = Lindgen(nrecs_ice)*Interval_ice           ; first record is at 0.
    times_atm = (Lindgen(nrecs_atm)+1)*Interval_atm           ; first record is at 0.
    
    work_structure_ice = set_ml1(nrecs = nrecs_ice,nvars = 10)
    work_structure_atm = set_ml1(nrecs = nrecs_atm,nvars = 5)
    error_structure_ice = set_ml1(nrecs = nrecs_ice,nvars = 10)
    error_structure_atm = set_ml1(nrecs = nrecs_atm,nvars = 5)
    work_structure_atm[*,*].DATA = array_atm[*,*]        
    work_structure_ice[*,*].DATA = array_ice[*,*]

    for var_no = 0,9 do begin
      work_structure_ice[*,var_no].NTIM = times_ice
    endfor
    for var_no = 0,4 do begin
      work_structure_atm[*,var_no].NTIM = times_atm
    endfor
    
    if expt_no EQ 0 then begin
      truth_structure_ice = work_structure_ice
      truth_structure_atm = work_structure_atm
    endif else begin
      for var_no = 0,9 do begin
	r = ml1_diff(work_structure_ice[*,var_no],truth_structure_ice[*,var_no])
	error_structure_ice[*,var_no] = r
      endfor
      for var_no = 0,4 do begin
	r = ml1_diff(work_structure_atm[*,var_no],truth_structure_atm[*,var_no])
	error_structure_atm[*,var_no] = r
      endfor
    endelse
    
    for var_no = 0,4 do begin
      work_structure_atm[*,var_no].NTIM = times_atm
    endfor
    
    varname='data_atm'+nicenumber(expt_no+1)
    r=execute(varname+'=work_structure_atm')
    savfile=savdir+'data_atm'+nicenumber(expt_no+1)+'.sav'
    r = execute('save, '+varname+', file=savfile')

    varname='data_ice'+nicenumber(expt_no+1)
    r=execute(varname+'=work_structure_ice')
    savfile=savdir+'data_ice'+nicenumber(expt_no+1)+'.sav'
    r = execute('save, '+varname+', file=savfile')

    varname='error_atm'+nicenumber(expt_no+1)
    r=execute(varname+'=error_structure_atm')
    savfile=savdir+'error_atm'+nicenumber(expt_no+1)+'.sav'
    r = execute('save, '+varname+', file=savfile')

    varname='error_ice'+nicenumber(expt_no+1)
    r=execute(varname+'=error_structure_ice')
    savfile=savdir+'error_ice'+nicenumber(expt_no+1)+'.sav'
    r = execute('save, '+varname+', file=savfile')
  endfor
endif else begin
  for expt_no=0,n_exps-1 do begin
    savfile=savdir+'data_ice'+nicenumber(expt_no+1)+'.sav'
    restore, savfile
    savfile=savdir+'data_atm'+nicenumber(expt_no+1)+'.sav'
    restore, savfile
    
    savfile=savdir+'error_ice'+nicenumber(expt_no+1)+'.sav'
    restore, savfile
    savfile=savdir+'error_atm'+nicenumber(expt_no+1)+'.sav'
    restore, savfile
  endfor
endelse

top = [.09,.89,.475,.98]

x1 = [.09,.59]
x2 = [.475,.975]
y1 = [.695,.40,.11]     - [.02,.05,-.025]
y2 = [.835,.55,.245]     - [.01,.04,-.035]
ye1 = [.615,.33,.03]    - [.03,.05,-.015  ]
ye2 = [.69,.405,.105] - [.02,.05,-.025]

xl = 1.04
yt = .87
ys = .25
xlength = .1
lc = 1.94

UM_color = 255
standard_color = 'FFA020'x

Pr, /EPS, /Portrait, file = outfile1, /Color
reset, thick = 3
!P.Multi = [11,11,1,1]
!P.Charsize = 1.7
ww = [48.,49.]*3600.*24.

ml1_plot, data_atm1, window = ww, varno = 1, position = top, $
  YTitle = 'Atmos temp (!Uo!NC)', xl_yprops = [.14,.07,.04], $
  YRange = [-8.5,-1.5], title = '(a)'
linekey_noconv, xl, yt - ys*0., title = 'Hi-res control (''HRC'', dz = 1cm, dt = 1s)', thick = 15, linestyle = 2, $
  xlength = xlength, charsize = lc
linekey_noconv, xl, yt - ys*1., title = '4-layer control (dz = 25cm, dt = 1s)', xlength = xlength, charsize = lc
linekey_noconv, xl, yt - ys*2., title = '''JULES'' coupling (dz = 25cm, ice dt = 1h,!Catmos dt = 20min, coupling dt = 1h)', $
  color = UM_color, xlength = xlength, charsize = lc
linekey_noconv, xl, yt - ys*3.8, title = '''CICE'' coupling (dz = 25cm, ice dt = 1h,!Catmos dt = 20min, coupling dt = 1h)', $
  color = standard_color, xlength = xlength, charsize = lc
XYOuts, (top[2]+top[0])/2., top[1] * 1.42 - top[3]*.42, alignment = .5, /normal, 'Hours', charsize = 1.

varno_use = 2
ml1_plot, data_atm1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-23,13], /no_xlegend, position = [x1[0],y1[0],x2[0],y2[0]], $
  YTitle = 'Surface flux (W/m!U2!N)', title = '(b)'
ml1_plot, data_atm2, window = ww, varno = varno_use, /overplot
ml1_plot, data_atm3, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
ml1_plot, data_atm4, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
  
ml1_plot, error_atm1, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-18,18], position = [x1[0],ye1[0],x2[0],ye2[0]], window = ww, $
  xl_yprops = [.18,.09,.04], YTickInterval = 10, $
  YMinor = 2, YTitle = 'Error wrt HRC'
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, error_atm2, varno = varno_use, $
  /overplot
ml1_plot, error_atm3, varno = varno_use, colours = standard_color, $
  /overplot
ml1_plot, error_atm4, varno = varno_use, colours = UM_color, $
  /overplot
XYOuts, (x1[0]+x2[0])/2., ye1[0] * 1.5 - ye2[0]*.5, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 3
ml1_plot, data_atm1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-5.5,-3.1], /no_xlegend, position = [x1[1],y1[0],x2[1],y2[0]], $
  YTitle = 'Surface temp (!Uo!NC),!Catmos model', title = '(c)'
ml1_plot, data_atm2, window = ww, varno = varno_use, /overplot
ml1_plot, data_atm3, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
ml1_plot, data_atm4, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
  
ml1_plot, error_atm1, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-1,1], position = [x1[1],ye1[0],x2[1],ye2[0]], window = ww, $
  xl_yprops = [.18,.09,.04], YTitle = 'Error wrt HRC'
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, error_atm2, varno = varno_use, $
  /overplot
ml1_plot, error_atm3, varno = varno_use, colours = standard_color, $
  /overplot
ml1_plot, error_atm4, varno = varno_use, colours = UM_color, $
  /overplot
XYOuts, (x1[1]+x2[1])/2., ye1[0] * 1.5 - ye2[0]*.5, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 3
ml1_plot, data_ice1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-6.0,-3.0], position = [x1[0],y1[1],x2[0],y2[1]], $
  YTitle = 'Surface temp (!Uo!NC), ice model', xl_yprops = [.09,.045,.02], $
  title = '(d)'
ml1_plot, data_ice2, window = ww, varno = varno_use, /overplot
ml1_plot, data_ice3, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
XYOuts, (x1[0]+x2[0])/2., y1[1] * 1.25 - y2[1]*.25, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 4
ml1_plot, data_atm2, window = ww, varno = varno_use, $
  YRange = [-4.6,-3.5], position = [x1[1],y1[1],x2[1],y2[1]], $
  YTitle = 'Top layer temp (!Uo!NC), atmos model', xl_yprops = [.09,.045,.02], $
  title = '(e)'
ml1_plot, data_atm4, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
XYOuts, (x1[1]+x2[1])/2., y1[1] * 1.25 - y2[1]*.25, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 5
ml1_plot, data_ice1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-4.6,-3.4], /no_xlegend, position = [x1[0],y1[2],x2[0],y2[2]], $
  YTitle = '.125m temp (!Uo!NC)', title = '(f)'
ml1_plot, data_ice2, window = ww, varno = varno_use, /overplot
ml1_plot, data_ice3, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
ml1_plot, data_ice4, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
  
ml1_plot, error_ice1, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-.12,.12], position = [x1[0],ye1[2],x2[0],ye2[2]], window = ww, $
  xl_yprops = [.18,.09,.04], YTitle = 'Error wrt HRC'
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, error_ice2, varno = varno_use, $
  /overplot
ml1_plot, error_ice3, varno = varno_use, colours = standard_color, $
  /overplot
ml1_plot, error_ice4, varno = varno_use, colours = UM_color, $
  /overplot
XYOuts, (x1[0]+x2[0])/2., ye1[2] * 1.5 - ye2[2]*.5, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 7
ml1_plot, data_ice1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-2.779,-2.721], /no_xlegend, position = [x1[1],y1[2],x2[1],y2[2]], $
  YTitle = '.625m temp (!Uo!NC)', title = '(g)'
ml1_plot, data_ice2, window = ww, varno = varno_use, /overplot
ml1_plot, data_ice3, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
ml1_plot, data_ice4, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
  
ml1_plot, error_ice1, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-.029,.029], position = [x1[1],ye1[2],x2[1],ye2[2]], window = ww, $
  xl_yprops = [.18,.09,.04], YTitle = 'Error wrt HRC'
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, error_ice2, varno = varno_use, $
  /overplot
ml1_plot, error_ice3, varno = varno_use, colours = standard_color, $
  /overplot
ml1_plot, error_ice4, varno = varno_use, colours = UM_color, $
  /overplot
XYOuts, (x1[1]+x2[1])/2., ye1[2] * 1.5 - ye2[2]*.5, alignment = .5, /normal, 'Hours', charsize = 1.
  
Prend, /keep, /noprint


Pr, /EPS, /Portrait, file = outfile2, /Color

ml1_plot, data_atm1, window = ww, varno = 1, position = top, $
  YTitle = 'Atmos temp (!Uo!NC)', xl_yprops = [.14,.07,.04], $
  YRange = [-8.5,-1.5], title = '(a)', /cpl3
linekey_noconv, xl, yt - ys*0., title = 'Hi-res control (''HRC'', dz = 1cm, dt = 1s)', thick = 15, linestyle = 2, $
  xlength = xlength, charsize = lc
linekey_noconv, xl, yt - ys*1., title = '4-layer control (dz = 25cm, dt = 1s)', xlength = xlength, charsize = lc
linekey_noconv, xl, yt - ys*2., title = '''JULES'' coupling (dz = 25cm, ice dt = 1h,!Catmos dt = 20min, coupling dt = 3h)', $
  color = UM_color, xlength = xlength, charsize = lc
linekey_noconv, xl, yt - ys*3.8, title = '''CICE'' coupling (dz = 25cm, ice dt = 1h,!Catmos dt = 20min, coupling dt = 3h)', $
  color = standard_color, xlength = xlength, charsize = lc
XYOuts, (top[2]+top[0])/2., top[1] * 1.42 - top[3]*.42, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 2
ml1_plot, data_atm1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-23,13], /no_xlegend, position = [x1[0],y1[0],x2[0],y2[0]], $
  YTitle = 'Surface flux (W/m!U2!N)', title = '(b)', /cpl3
ml1_plot, data_atm2, window = ww, varno = varno_use, /overplot
ml1_plot, data_atm5, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
ml1_plot, data_atm6, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
  
ml1_plot, error_atm1, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-18,18], position = [x1[0],ye1[0],x2[0],ye2[0]], window = ww, $
  xl_yprops = [.18,.09,.04], YTickInterval = 10, $
  YMinor = 2, YTitle = 'Error wrt HRC', /cpl3
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, error_atm2, varno = varno_use, $
  /overplot
ml1_plot, error_atm5, varno = varno_use, colours = standard_color, $
  /overplot
ml1_plot, error_atm6, varno = varno_use, colours = UM_color, $
  /overplot
XYOuts, (x1[0]+x2[0])/2., ye1[0] * 1.5 - ye2[0]*.5, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 3
ml1_plot, data_atm1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-6.0,-3.0], /no_xlegend, position = [x1[1],y1[0],x2[1],y2[0]], $
  YTitle = 'Surface temp (!Uo!NC),!Catmos model', title = '(c)', /cpl3
ml1_plot, data_atm2, window = ww, varno = varno_use, /overplot
ml1_plot, data_atm5, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
ml1_plot, data_atm6, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
  
ml1_plot, error_atm1, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-1,1], position = [x1[1],ye1[0],x2[1],ye2[0]], window = ww, $
  xl_yprops = [.18,.09,.04], YTitle = 'Error wrt HRC', /cpl3
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, error_atm2, varno = varno_use, $
  /overplot
ml1_plot, error_atm5, varno = varno_use, colours = standard_color, $
  /overplot
ml1_plot, error_atm6, varno = varno_use, colours = UM_color, $
  /overplot
XYOuts, (x1[1]+x2[1])/2., ye1[0] * 1.5 - ye2[0]*.5, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 3
ml1_plot, data_ice1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-6.0,-3.0], position = [x1[0],y1[1],x2[0],y2[1]], $
  YTitle = 'Surface temp (!Uo!NC), ice model', xl_yprops = [.09,.045,.02], $
  title = '(d)', /cpl3
ml1_plot, data_ice2, window = ww, varno = varno_use, /overplot
ml1_plot, data_ice5, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
XYOuts, (x1[0]+x2[0])/2., y1[1] * 1.25 - y2[1]*.25, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 4
ml1_plot, data_atm2, window = ww, varno = varno_use, $
  YRange = [-4.6,-3.5], xl_yprops = [.09,.045,.02], position = [x1[1],y1[1],x2[1],y2[1]], $
  YTitle = 'Top layer temp (!Uo!NC), atmos model', title = '(e)'  , /cpl3
ml1_plot, data_atm6, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
XYOuts, (x1[1]+x2[1])/2., y1[1] * 1.25 - y2[1]*.25, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 5
ml1_plot, data_ice1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-4.6,-3.4], /no_xlegend, position = [x1[0],y1[2],x2[0],y2[2]], $
  YTitle = '.125m temp (!Uo!NC)', title = '(f)', /cpl3
ml1_plot, data_ice2, window = ww, varno = varno_use, /overplot
ml1_plot, data_ice3, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
ml1_plot, data_ice4, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
  
ml1_plot, error_ice1, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-.12,.12], position = [x1[0],ye1[2],x2[0],ye2[2]], window = ww, $
  xl_yprops = [.18,.09,.04], YTitle = 'Error wrt HRC', /cpl3
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, error_ice2, varno = varno_use, $
  /overplot
ml1_plot, error_ice3, varno = varno_use, colours = standard_color, $
  /overplot
ml1_plot, error_ice4, varno = varno_use, colours = UM_color, $
  /overplot
XYOuts, (x1[0]+x2[0])/2., ye1[2] * 1.5 - ye2[2]*.5, alignment = .5, /normal, 'Hours', charsize = 1.
  
varno_use = 7
ml1_plot, data_ice1, window = ww, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-2.779,-2.721], /no_xlegend, position = [x1[1],y1[2],x2[1],y2[2]], $
  YTitle = '.625m temp (!Uo!NC)', title = '(g)', /cpl3
ml1_plot, data_ice2, window = ww, varno = varno_use, /overplot
ml1_plot, data_ice3, window = ww, varno = varno_use, /overplot, $
  colours = standard_color;, psyms = -2
ml1_plot, data_ice4, window = ww, varno = varno_use, /overplot, $
  colours = UM_color;, psyms = -2
  
ml1_plot, error_ice1, varno = varno_use, linestyles = 2, thicks = 15, $
  YRange = [-.029,.029], position = [x1[1],ye1[2],x2[1],ye2[2]], window = ww, $
  xl_yprops = [.18,.09,.04], YTitle = 'Error wrt HRC', /cpl3
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, error_ice2, varno = varno_use, $
  /overplot
ml1_plot, error_ice3, varno = varno_use, colours = standard_color, $
  /overplot
ml1_plot, error_ice4, varno = varno_use, colours = UM_color, $
  /overplot
XYOuts, (x1[1]+x2[1])/2., ye1[2] * 1.5 - ye2[2]*.5, alignment = .5, /normal, 'Hours', charsize = 1.

Prend, /keep, /noprint

END
