; Plot 4-panel figure of solutions to 1-D temperature solver.
datadiry='/data/local/hadax/MULTI_LAYERS/CICE_1D/'
savdir='/data/cr1/hadax/1D_Multilayers/expt1/'
nilyr=[100,4,100,4,100,4]
dt=[1.,1.,3600.,3600.,3600.,3600.]
min_print=[60,60,1,1,1,1]
atmos_dt=[1.,1.,1200.,1200.,1200.,1200.]
cpl_dt=[1.,1.,3600.,3600.,10800.,10800.]
n_exps=6
read_data=0
outfiles='~hadax/graphics/1D_Multilayers/Paper/'+['expt1_try_cp1h_a.eps','expt1_try_cp3h_a.eps']
extract_pts=[1,3]

filenames='data.'+string(int(dt),format='(I5.5)')+'.'+$
  string(int(cpl_dt),format='(I5.5)')+'.'+$
  string(int(atmos_dt),format='(I5.5)')+'.'+$
  string(nilyr,format='(I3.3)')+'.dat'
files=datadiry+filenames

if read_data then begin
  data_analytic=set_analytic_solution(interval=60.,nrecs=60L*24L*50L+1)
  save, data_analytic, file=savdir+'data_analytic.sav'
  for expt_no=0,n_exps-1 do begin
    print, 'Reading in data for experiment '+nicenumber(expt_no+1)
    array=ml1_read(files[expt_no],nskip=2,nrecs=nrecs)
    interval=dt[expt_no]
    times=(Lindgen(nrecs)+1)*int(interval)*min_print[expt_no]

    work_structure=set_ml1(nrecs=nrecs,nvars=4)
    work_structure[*,0:1].DATA=array[*,extract_pts]
    work_structure[*,0:1].NTIM=reform(replicate_cyclic(times,nrecs*2),nrecs,2)

    error_structure_Tsfc=ml1_diff(work_structure[*,0],data_analytic[*,0])
    work_structure[*,2]=error_structure_Tsfc
    error_structure_T_pt125=ml1_diff(work_structure[*,1],data_analytic[*,1],debug=(expt_no EQ 2))
    work_structure[*,3]=error_structure_T_pt125

    savfile=savdir+'data'+nicenumber(expt_no+1)+'.sav'
    save, work_structure, file=savfile
    varname='data'+nicenumber(expt_no+1)
    r=execute(varname+'=work_structure')
  endfor
endif else begin
  for expt_no=0,n_exps-1 do begin
    savfile=savdir+'data'+nicenumber(expt_no+1)+'.sav'
    restore, savfile
    varname='data'+nicenumber(expt_no+1)
    r=execute(varname+'=work_structure')
  endfor
  restore, savdir+'data_analytic.sav'
endelse
  
reset, thick=4

analytic_colour='408000'x
titles=['Hi-res','Reduced vertical','Reduced temporal','Low-res','3hr cpling 100-layer',$
  '3hr cpling 4-layer']
ptitles=['(a)','(b)','(c)','(d)']
pytitles=['Temperature (deg C)',' ','Temperature (deg C)',' ']
YR=[[-3.5,0],[-2.4,-1.2],[-1.0,1.0],[-0.15,0.15]]
x1=[.14,.62]
x2=[.5,.98]
y1=[.48]
y2=[.95]
ye1=[.27]
ye2=[.48]

xl = -1.4
yt = -0.7
ys = 0.2
xs = 1.2

Pr, /EPS, /Landscape, file=outfiles[0], /color
reset, thick = 4
!P.Multi = [4,4,1,1]
!P.Charsize = 2.4
colors=[0,0,'FF0000'x,'FF0000'x,'0000FF'x,'0000FF'x]
psyms=[0,0,-2,-2,-2,-2]
linestyles=[0,1,0,1,0,1]
titles=['Hi-res','Reduced vertical','Reduced temporal','Low-res','3hr cpling 100-layer',$
  '3hr cpling 4-layer']
day_to_plot=48.
ww = ([0,1]+day_to_plot)*3600.*24.

hires_1s_color = 'A0FF00'x
lowres_1s_color = 0
hires_1h_color = '0040A0'x
lowres_1h_color = 'FF6030'x
hires_3h_color = '0040A0'x
lowres_3h_color = 'FF6030'x

nplot = 0
ml1_plot, data1, varno = 0, window = ww, position=[x1[nplot mod 2],y1[nplot/2],x2[nplot mod 2],y2[nplot/2]], $
  /no_xlegend, YRange = [-3.4,-.1], YTitle = 'Surface temperature (deg C)', $
  title = '(a)', colours = hires_1s_color, linestyles = 5
ml1_plot, data_analytic, varno = 0, /overplot, thicks = 15
ml1_plot, data1, varno = 0, window = ww, /overplot, colours = hires_1s_color, linestyle = 5
ml1_plot, data2, varno = 0, window = ww, /overplot, colours = lowres_1s_color, linestyle = 5
ml1_plot, data3, varno = 0, window = ww, /overplot, colours = hires_1h_color, linestyle = 5
ml1_plot, data4, varno = 0, window = ww, /overplot, colours = lowres_1h_color, linestyle = 5
ml1_plot, data1, varno = 2, window = ww, position=[x1[nplot mod 2],ye1[nplot/2],x2[nplot mod 2],ye2[nplot/2]], $
  YTitle = 'Error wrt AS', YRange = [-.9,.9], xl_yprops = [.18,.09,.04], colours = hires_1s_color, linestyle = 5
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, data1, varno = 2, window = ww, /overplot, colours = hires_1s_color, linestyle = 5
ml1_plot, data2, varno = 2, window = ww, /overplot, colours = lowres_1s_color, linestyle = 5
ml1_plot, data3, varno = 2, window = ww, /overplot, colours = hires_1h_color, linestyle = 5
ml1_plot, data4, varno = 2, window = ww, /overplot, colours = lowres_1h_color, linestyle = 5

XYOuts, (x1[0]+x2[0])/2., ye1 - .53*(ye2 - ye1), 'Hours', alignment = .5, /normal, charsize = 1.4

nplot = 1
ml1_plot, data1, varno = 1, window = ww, position=[x1[nplot mod 2],y1[nplot/2],x2[nplot mod 2],y2[nplot/2]], $
  /no_xlegend, YRange = [-2.39,-1.21], YTitle = '.125m temperature (deg C)', $
  title = '(b)', colours = hires_1s_color, linestyles = 5
ml1_plot, data_analytic, varno = 1, /overplot, thicks = 15
ml1_plot, data1, varno = 1, window = ww, /overplot, colours = hires_1s_color, linestyle = 5
ml1_plot, data2, varno = 1, window = ww, /overplot, colours = lowres_1s_color, linestyle = 5
ml1_plot, data3, varno = 1, window = ww, /overplot, colours = hires_1h_color, linestyle = 5
ml1_plot, data4, varno = 1, window = ww, /overplot, colours = lowres_1h_color, linestyle = 5
ml1_plot, data1, varno = 3, window = ww, position=[x1[nplot mod 2],ye1[nplot/2],x2[nplot mod 2],ye2[nplot/2]], $
  YTitle = 'Error wrt AS', YRange = [-.13,.13], xl_yprops = [.18,.09,.04], colours = hires_1s_color, linestyle = 5
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, data1, varno = 3, window = ww, /overplot, colours = hires_1s_color, linestyle = 5
ml1_plot, data2, varno = 3, window = ww, /overplot, colours = lowres_1s_color, linestyle = 5
ml1_plot, data3, varno = 3, window = ww, /overplot, colours = hires_1h_color, linestyle = 5
ml1_plot, data4, varno = 3, window = ww, /overplot, colours = lowres_1h_color, linestyle = 5

XYOuts, (x1[1]+x2[1])/2., ye1 - .53*(ye2 - ye1), 'Hours', alignment = .5, /normal, charsize = 1.4

linekey_noconv, xl, yt, title = 'Hi-res 1S', $
  xlength = .25, color = hires_1s_color, linestyle = 5
linekey_noconv, xl, yt - ys, title = 'Low-res 1S', $
  xlength = .25, color = lowres_1s_color, linestyle = 5
linekey_noconv, xl + xs, yt, title = 'Hi-res 1H', $
  xlength = .25, color = hires_1h_color, linestyle = 5
linekey_noconv, xl + xs, yt - ys, title = 'Low-res 1H', $
  xlength = .25, color = lowres_1h_color, linestyle = 5
linekey_noconv, xl , yt - ys * 2, title = 'Analytic solution (AS)', $
  xlength = .25, thick = 15




Pr, /EPS, /Landscape, file=outfiles[1], /color

nplot = 0
ml1_plot, data1, varno = 0, window = ww, position=[x1[nplot mod 2],y1[nplot/2],x2[nplot mod 2],y2[nplot/2]], $
  /no_xlegend, YRange = [-3.4,-.1], YTitle = 'Surface temperature (deg C)', $
  title = '(a)', colours = hires_1s_color, linestyle = 5, /cpl3
ml1_plot, data_analytic, varno = 0, /overplot, thicks = 15
ml1_plot, data1, varno = 0, window = ww, /overplot, colours = hires_1s_color, linestyle = 5
ml1_plot, data2, varno = 0, window = ww, /overplot, colours = lowres_1s_color, linestyle = 5
ml1_plot, data5, varno = 0, window = ww, /overplot, colours = hires_3h_color, linestyle = 5
ml1_plot, data6, varno = 0, window = ww, /overplot, colours = lowres_3h_color, linestyle = 5
ml1_plot, data1, varno = 2, window = ww, position=[x1[nplot mod 2],ye1[nplot/2],x2[nplot mod 2],ye2[nplot/2]], $
  YTitle = 'Error wrt AS', YRange = [-.9,.9], xl_yprops = [.18,.09,.04], colours = hires_1s_color, linestyle = 5, /cpl3
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, data1, varno = 2, window = ww, /overplot, colours = hires_1s_color, linestyle = 5
ml1_plot, data2, varno = 2, window = ww, /overplot, colours = lowres_1s_color, linestyle = 5
ml1_plot, data5, varno = 2, window = ww, /overplot, colours = hires_3h_color, linestyle = 5
ml1_plot, data6, varno = 2, window = ww, /overplot, colours = lowres_3h_color, linestyle = 5

XYOuts, (x1[0]+x2[0])/2., ye1 - .53*(ye2 - ye1), 'Hours', alignment = .5, /normal, charsize = 1.4

nplot = 1
ml1_plot, data1, varno = 1, window = ww, position=[x1[nplot mod 2],y1[nplot/2],x2[nplot mod 2],y2[nplot/2]], $
  /no_xlegend, YRange = [-2.39,-1.21], YTitle = '.125m temperature (deg C)', $
  title = '(b)', colours = hires_1s_color, linestyle = 5, /cpl3
ml1_plot, data_analytic, varno = 1, /overplot, thicks = 15
ml1_plot, data1, varno = 1, window = ww, /overplot, colours = hires_1s_color, linestyle = 5
ml1_plot, data2, varno = 1, window = ww, /overplot, colours = lowres_1s_color, linestyle = 5
ml1_plot, data5, varno = 1, window = ww, /overplot, colours = hires_3h_color, linestyle = 5
ml1_plot, data6, varno = 1, window = ww, /overplot, colours = lowres_3h_color, linestyle = 5
ml1_plot, data1, varno = 3, window = ww, position=[x1[nplot mod 2],ye1[nplot/2],x2[nplot mod 2],ye2[nplot/2]], $
  YTitle = 'Error wrt AS', YRange = [-.13,.13], xl_yprops = [.18,.09,.04], colours = hires_1s_color, linestyle = 5, /cpl3
oplot, ww, [0,0], linestyle = 1, thick = 1
ml1_plot, data1, varno = 3, window = ww, /overplot, colours = hires_1s_color, linestyle = 5
ml1_plot, data2, varno = 3, window = ww, /overplot, colours = lowres_1s_color, linestyle = 5
ml1_plot, data5, varno = 3, window = ww, /overplot, colours = hires_3h_color, linestyle = 5
ml1_plot, data6, varno = 3, window = ww, /overplot, colours = lowres_3h_color, linestyle = 5

linekey_noconv, xl, yt, title = 'Hi-res 1S', $
  xlength = .15, color = hires_1s_color, linestyle = 5
linekey_noconv, xl, yt - ys, title = 'Low-res 1S', $
  xlength = .15, color = lowres_1s_color, linestyle = 5
linekey_noconv, xl + xs, yt, title = 'Hi-res 3H', $
  xlength = .15, color = hires_3h_color, linestyle = 5
linekey_noconv, xl + xs, yt - ys, title = 'Low-res 3H', $
  xlength = .15, color = lowres_3h_color, linestyle = 5
linekey_noconv, xl , yt - ys * 2, title = 'Analytic solution', $
  xlength = .15, thick = 15

XYOuts, (x1[1]+x2[1])/2., ye1 - .53*(ye2 - ye1), 'Hours', alignment = .5, /normal, charsize = 1.4

Prend, /keep, /noprint
END
