;------------------------------------------------------------------------------- 
;	NAME
;		var_set
;
;	PURPOSE
;		IDL function to check if a variable is valid variable or keyword
;
;	USAGE
;		if var_set(var) then
;		if var_set(var,/not_keyword) then 
;		if var_set(var,/keyword_only) then 
;
;	INPUT
;		var : variable
;
;	KEYWORD
;		not_keyword  : return 1 when a variable is set but not keyword
;		keyword_only : return 1 when a variable is set as a keyword (/var or var=1)
;
;	AUTHOR
;		2007-01-12 Hyun Cheol Kim (hyuncheol.kim@gmail.com, hkim2@mail.uh.edu)
; 
;------------------------------------------------------------------------------- 

	function var_set,var1,var2,var3,var4,var5,var6,var7,var8,var9, $
 	         not_keyword=not_keyword,keyword_only=keyword_only,if_any=if_any,$
	         equal=equal,value=value,ina=ina

;------------------------------------------------------------------------------- 
 
case 1 of

	keyword_set(equal) : begin			
		if n_elements(var1) eq 0 then return,0B
		if n_elements(var2) eq 0 then return,0B		
		return,array_equal(var1,var2)	
		end
								
	keyword_set(if_any) : begin
	
		nn = [n_elements(var1),n_elements(var2),n_elements(var3),n_elements(var4),$
		      n_elements(var5),n_elements(var6),n_elements(var7),n_elements(var8),n_elements(var9)]
		      
		return,total(nn) ne 0		      
	
		end

	keyword_set(not_keyword) : begin
	
		case n_params() of
		
			1 : begin
	
	  			case n_elements(var1) of
		
		  			0 : return,0B
					1 : if var1 eq 1 and size(var1,/n_dim) eq 0 and size(var1,/type) eq 2 then return,0B else return,1B
					else : return,1B
		
				endcase
				end
				
			2 : return,var_set(var1,/not_keyword)*var_set(var2,/not_keyword)
			3 : return,var_set(var1,var2,/not_keyword)*var_set(var3,/not_keyword)
			4 : return,var_set(var1,var2,var3,/not_keyword)*var_set(var4,/not_keyword)
			5 : return,var_set(var1,var2,var3,var4,/not_keyword)*var_set(var5,/not_keyword)
			6 : return,var_set(var1,var2,var3,var4,var5,/not_keyword)*var_set(var6,/not_keyword)
			7 : return,var_set(var1,var2,var3,var4,var5,var6,/not_keyword)*var_set(var7,/not_keyword)
			8 : return,var_set(var1,var2,var3,var4,var5,var6,var7,/not_keyword)*var_set(var8,/not_keyword)
			9 : return,var_set(var1,var2,var3,var4,var5,var6,var7,var8,/not_keyword)*var_set(var9,/not_keyword)
		
			else : message,'AVAILABLE UP TO 4 VARIABLES'							
		endcase							
			
		end
					
	keyword_set(keyword_only) : begin
	
		case n_params() of
		
			1 : begin
	
	  		case n_elements(var1) of
		
		  		0 : return,0B
				1 : begin
					if size(var1,/n_dim) eq 0 and size(var1,/type) eq 2 then begin
						if var1 eq 1 then return,1B else return,0B
					endif else return,0B
					end						 			
				else : return,0B
		
				endcase 	
				end
				
			2 : return,var_set(var1,/keyword_only)*var_set(var2,/keyword_only)
			3 : return,var_set(var1,var2,/keyword_only)*var_set(var3,/keyword_only)
			4 : return,var_set(var1,var2,var3,/keyword_only)*var_set(var4,/keyword_only)
			5 : return,var_set(var1,var2,var3,var4,/keyword_only)*var_set(var5,/keyword_only)
			6 : return,var_set(var1,var2,var3,var4,var5,/keyword_only)*var_set(var6,/keyword_only)
			7 : return,var_set(var1,var2,var3,var4,var5,var6,/keyword_only)*var_set(var7,/keyword_only)
			8 : return,var_set(var1,var2,var3,var4,var5,var6,var7,/keyword_only)*var_set(var8,/keyword_only)
			9 : return,var_set(var1,var2,var3,var4,var5,var6,var7,var8,/keyword_only)*var_set(var9,/keyword_only)
			
			else : message,'AVAILABLE UP TO 4 VARIABLES'
		endcase	
		end
		
	n_elements(value) ne 0 : begin
	
		if n_elements(var1) ne n_elements(value) then return,0b 				
		if str(var1,/is_number) ne str(value,/is_number) then return,0b		
		return,array_equal(var1,value)				
		end
		
	n_elements(ina) ne 0 : if n_elements(var1) ne 0 then return,var1 else return,ina
							
	else : begin
		
		case n_params() of
		
			1 : if n_elements(var1) eq 0 then return,0B else return,1B
			2 : return,var_set(var1)*var_set(var2)
			3 : return,var_set(var1,var2)*var_set(var3)
			4 : return,var_set(var1,var2,var3)*var_set(var4)
			5 : return,var_set(var1,var2,var3,var4)*var_set(var5)
			6 : return,var_set(var1,var2,var3,var4,var5)*var_set(var6)
			7 : return,var_set(var1,var2,var3,var4,var5,var6)*var_set(var7)
			8 : return,var_set(var1,var2,var3,var4,var5,var6,var7)*var_set(var8)
			9 : return,var_set(var1,var2,var3,var4,var5,var6,var7,var8)*var_set(var9)
			
			else : message,'AVAILABLE UP TO 9 VARIABLES'
		
		endcase					
		end

endcase

end
