;-------------------------------------------------------------------------------
;	NAME
;		struct_write
;
;	PURPOSE
;		to write(add) data into given structure
;
;	USAGE
;		r = struct_write(s1,'tag1',data[,/preserve_tye])
;		r = struct_write(s1,['aa','aa.bb'],0,['bb.cc.dd'],10)
;
;
;	INPUT
;		s1 : target structure
;		t2,t3,... : tag names
;		d2,d3,... : data 
;
;	KEYWORD
;		preserve_type : keep origianl data ytpe of s1
;
;	AUTHOR
;		2012-06-08 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2013-05-23 added structure checking for s1
;-------------------------------------------------------------------------------

	function struct_write1,s1,_t2,d2,preserve_type=_pt
	
;-------------------------------------------------------------------------------

t1 = n_tags(s1) eq 0 ? '' : tag_names(s1[0])
t2 = str(/up,strsplit(_t2[0],'.',/extract))

x = where(t1 eq t2[0],nx)

if nx eq 0 then begin

	rr = n_tags(s1) eq 0 ? struct_make(strjoin(_t2,'.'),d2) : create_struct(s1,struct_make(strjoin(_t2,'.'),d2))

endif else begin

	if n_elements(t2) eq 1 then begin
	
		for it1=0L,n_elements(t1)-1 do begin
		
			rr = var_set(rr) ? create_struct(rr,t1[it1],it1 eq x ? (keyword_set(_pt) ? data_type(d2,size(s1.(it1),/type)) : d2) : s1.(it1)) $
			                 : create_struct(t1[it1],it1 eq x ? (keyword_set(_pt) ? data_type(d2,size(s1.(it1),/type)) : d2) : s1.(it1))
		
		endfor
	
	endif else begin
	
		for it1=0L,n_elements(t1)-1 do begin
		
			rr = var_set(rr) ? create_struct(rr,t1[it1],it1 eq x ? struct_write1(s1.(it1),strjoin(t2[1:*],'.'),d2,preserve_type=_pt) : s1.(it1)) $
		                         : create_struct(t1[it1],it1 eq x ? struct_write1(s1.(it1),strjoin(t2[1:*],'.'),d2,preserve_type=_pt) : s1.(it1))
		
		endfor
	
	endelse

endelse

return,rr

end
;-------------------------------------------------------------------------------

	function struct_write,s1,t2,d2,t3,d3,t4,d4,t5,d5,t6,d6,t7,d7,t8,d8,t9,d9,t10,d10,t11,d11,t12,d12,t13,d13,t14,d14,t15,d15,t16,d16,t17,d17,$
	         preserve_type=_pt
	
;-------------------------------------------------------------------------------

if n_elements(s1) eq 1 then begin

	if var_set(t2,d2) then for it2=0L,n_elements(t2)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t2[it2],d2,preserve_type=_pt)
	if var_set(t3,d3) then for it2=0L,n_elements(t3)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t3[it2],d3,preserve_type=_pt)
	if var_set(t4,d4) then for it2=0L,n_elements(t4)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t4[it2],d4,preserve_type=_pt)  
	if var_set(t5,d5) then for it2=0L,n_elements(t5)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t5[it2],d5,preserve_type=_pt)
	if var_set(t6,d6) then for it2=0L,n_elements(t6)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t6[it2],d6,preserve_type=_pt)
	if var_set(t7,d7) then for it2=0L,n_elements(t7)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t7[it2],d7,preserve_type=_pt)  
	if var_set(t8,d8) then for it2=0L,n_elements(t8)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t8[it2],d8,preserve_type=_pt)
	if var_set(t9,d9) then for it2=0L,n_elements(t9)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t9[it2],d9,preserve_type=_pt)
	if var_set(t10,d10) then for it2=0L,n_elements(t10)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t10[it2],d10,preserve_type=_pt)
	if var_set(t11,d11) then for it2=0L,n_elements(t11)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t11[it2],d11,preserve_type=_pt)
	if var_set(t12,d12) then for it2=0L,n_elements(t12)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t12[it2],d12,preserve_type=_pt)
	if var_set(t13,d13) then for it2=0L,n_elements(t13)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t13[it2],d13,preserve_type=_pt)
	if var_set(t14,d14) then for it2=0L,n_elements(t14)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t14[it2],d14,preserve_type=_pt)
	if var_set(t15,d15) then for it2=0L,n_elements(t15)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t15[it2],d15,preserve_type=_pt)
	if var_set(t16,d16) then for it2=0L,n_elements(t16)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t16[it2],d16,preserve_type=_pt)
	if var_set(t17,d17) then for it2=0L,n_elements(t17)-1 do s2 = struct_write1(var_set(s2) ? s2 : s1,t17[it2],d17,preserve_type=_pt)
				
endif else begin

	s2a = struct_write(s1[0],t2,d2)
	
	if ~var_set(s2) then s2 = replicate(s2a,n_elements(s1))
	
	for is1=0L,n_elements(s1)-1 do s2[is1] = s2a
	
endelse

return,s2

end
