;-------------------------------------------------------------------------------
;	NAME
;		struct_tag
;
;	PURPOSE
;		returns tag names of given structure
;	
;	INPUT
;		s1 : strucutre 		
;
;	KEYWORD	
;		full : returns full combination
;			(AA.BB.CC --> AA AA.BB AA.BB.CC)
;
;	AUTHOR
;		2012-06-08 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function struct_tag,s1,full=full
	
;-------------------------------------------------------------------------------

ntag = n_tags(s1)

if ntag eq 0 then return,''

name = tag_names(s1)

for itag=0L,ntag-1 do begin

	name1 = struct_tag(s1.(itag),full=full)
	if name1[0] ne '' then name1 = '.'+name1

	rr = var_set(rr) ? [rr,name[itag]+name1] : [name[itag]+name1]  
		
	if keyword_set(full) then rr = array([rr,name[itag]],/uniq)

endfor

return,rr

end
