;-------------------------------------------------------------------------------
;	NAME
;		struct_set
;
;	PURPOSE
;		to test if a structure exists, or it has certain tag name(s)
;
;	INUPT
;		s1 : structure
;		t2 : tag name(s)
;
;	KEYWORD
;		if_any : returns 1 if any of given tag names exist
;		mask   : return test results in 0/1 mask
;
;	AUTHOR
;		2012-06-08 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function struct_set,s1,t2,if_any=if_any,mask=mask
	
;-------------------------------------------------------------------------------

if n_tags(s1) eq 0 then return,0B
if ~var_set(t2) then return,1B

rr = idx(struct_tag(s1,/full),str(/up,t2),/point) ge 0

case 1 of

	keyword_set(mask) : 
	keyword_set(if_any) : rr = total(rr) ne 0
	else : rr = total(rr) eq n_elements(rr)

endcase

return,rr

end
