;-------------------------------------------------------------------------------
;	NAME
;		strcut_retag
;
;	PURPOSE
;		ro reduce/rename tags
;
;	USAGE
;		r = struct_retag(s1,[tag=|,itag=][,rename=])
;
;		a = [{aa:3,bb:4,cc:5},{aa:12,bb:23,cc:34},{aa:123,bb:234,cc:345}]
;
;		b = struct_retag(a,tag=['aa','bb'])  --> reduce
;		c = struct_retag(a,itag=[1,2])  --> reduce
;		d = struct_retag(a,rename=['QW','DF','adf']) --> rename
;		e = struct_retag(a,tag=['aa','bb'],rename=['QW','DF'])  --> rename
;		f = struct_retag(a,itag=[1,2],rename=['QW','adf'])
;
;	INPUT	
;		s1     : structure
;		tag    : tag name to select
;		itag   : tag index to select
;		rename : rename tag names
;
;	AUTHOR
;		2013-09-25 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function struct_retag1,s1,tag=_tag1,itag=_itag,rename=_tag2,otag=tag2,oitag=itag
	
;-------------------------------------------------------------------------------	

aa   = struct_list(s1,otag=tag1)
itag = var_set(_itag) ? _itag : (var_set(_tag1) ? (xx=idx(tag1,str(/up,_tag1),/contain)) : lindgen(n_elements(tag1)))

if var_set(xx) then if min(xx) eq -1 then message,str(/join,'NO_TAQ_available:',_tag1[idx(tag1,str(/up,_tag1),/point) eq -1])

tag2 = var_set(_tag2) ? _tag2 : tag1[itag]
rr   = struct_make(tag2,aa[itag],/extract)

return,rr
end
;-------------------------------------------------------------------------------

	function struct_retag,s1,tag=_tag1,itag=_itag,rename=_tag2

;-------------------------------------------------------------------------------

if n_elements(s1) eq 1 then return,struct_retag1(s1,tag=_tag1,itag=_itag,rename=_tag2)

s2 = replicate(struct_retag1(s1[0],tag=_tag1,itag=_itag,rename=_tag2,otag=tag2,oitag=itag),n_elements(s1))

for i=0L,n_elements(tag2)-1 do s2.(i) = s1.(itag[i])

return,s2
end
