;-------------------------------------------------------------------------------
;	NAME
;		strcut_read
;
;	PURPOSE
;		ro read data from given structure
;
;	USAGE
;		r = struct_read(s1,'tag'[,na][,/structure])
;
;	INPUT	
;		s1 : structure
;		t1 : tag name
;		na : if tag is not available, then return na
;
;	KEYWORD
;		structure : keep data structure, and return structure
;
;	AUTHOR
;		2012-06-08 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2013-08-01 fixed bug (arrayed structure)
;-------------------------------------------------------------------------------

	function struct_read1,s1,_t1,na
	
;-------------------------------------------------------------------------------

if ~var_set(na) then na = need_null()
if n_tags(s1[0]) eq 0 then return,na

t1 = strsplit(_t1[0],'.',/extract)
x  = where(tag_names(s1[0]) eq str(/up,t1[0]),nx)

if nx eq 0 then return,na
if n_elements(t1) eq 1 then return,s1[0].(x) else return,struct_read1(s1[0].(x),strjoin(t1[1:*],'.'),na)

end
;-------------------------------------------------------------------------------

	function struct_read,s1,t1,na,structure=structure
	
;-------------------------------------------------------------------------------

if ~var_set(na) then na = need_null()
if n_elements(s1) eq 0 then return,na

if n_elements(s1) eq 1 then begin
	
	t1 = t1[(xx=idx(str(/up,t1),struct_tag(s1[0]),/contain))]
	if xx[0] eq -1 then return,na
		
	if n_elements(t1) eq 1 then begin
			
		rr = struct_read1(s1,t1[0],na)
	
		if keyword_set(structure) then rr = struct_make(t1[0],rr)
							
	endif else begin
	
		for it1=0L,n_elements(t1)-1 do begin
			
			rr = var_set(rr) ? struct_write(rr,t1[it1],struct_read1(s1,t1[it1],na)) $
			                 : struct_make(t1[it1],struct_read1(s1,t1[it1],na))
		
		endfor

	endelse
	
endif else begin
		
	for is1=0L,n_elements(s1)-1 do begin
	
		rr1 = struct_read(s1[is1],t1,na,structure=structure)
				
		if ~var_set(rr) then rr = replicate(rr1,n_elements(s1))
		rr[is1] = rr1
	
	endfor
		
endelse	

return,rr

end
