;-------------------------------------------------------------------------------
;	NAME
;		struct_merge
;
;	PURPOSE
;		to merge two structures
;
;	USAGE
;		r = struct_merge(s1,s2[,/update,/new,/preserve_type])
;
;	INPUT
;		s1,s2 : structures
;
;	KEYWORD
;		update : change values of s1 only if s1 and s2 have common tags
;		         (data type is preserved)
;		new    : add values if s2 has tags that don't exist in s1
;		preserve_type : keep data type of s1
;
;	AUTHOR
;		2012-06-08 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function struct_merge1,s1,s2,update=update,new=new,preserve_type=_pt
	
;-------------------------------------------------------------------------------

if ~struct_set(s1) and ~struct_set(s2) then return,0B
if ~struct_set(s1) and  struct_set(s2) then return,s2
if  struct_set(s1) and ~struct_set(s2) then return,s1

t1 = struct_tag(s1)
t2 = struct_tag(s2)
xx = idx(t1,t2,/point)

rr = s1

for it2=0L,n_elements(t2)-1 do begin

	case 1 of
	
		keyword_set(update) : if xx[it2] ne -1 then rr = struct_write(rr,t2[it2],data_type(struct_read(s2,t2[it2]),size(struct_read(s1,t2[it2]),/type)))
		keyword_set(new)    : if xx[it2] eq -1 then rr = struct_write(rr,t2[it2],struct_read(s2,t2[it2]))
		else : rr = struct_write(rr,t2[it2],xx[it2] ne -1 and keyword_set(_pt) ? data_type(struct_read(s2,t2[it2]),size(struct_read(s1,t2[it2]),/type)) : struct_read(s2,t2[it2]))
	
	endcase

endfor

return,rr

end
;-------------------------------------------------------------------------------

	function struct_merge,s1,_s2,update=update,new=new,preserve_type=_pt
	
;-------------------------------------------------------------------------------

if ~struct_set(s1) and ~struct_set(_s2) then return,0B
if ~struct_set(s1) and  struct_set(_s2) then return,_s2
if  struct_set(s1) and ~struct_set(_s2) then return,s1

dim1 = size(s1,/dim)
dim2 = size((s2 = n_elements(_s2) eq 1 ? replicate(_s2,dim1) : _s2),/dim)
dim3 = dim1 < dim2

for is1=0L,product(dim3)-1 do begin

	rr1 = struct_merge1(s1[is1],s2[is1],update=update,new=new,preserve_type=_pt)
	
	if ~var_set(rr) then rr = replicate(rr1,dim3)
	
	rr[is1] = rr1

endfor

return,rr

end
