;-------------------------------------------------------------------------------
;	NAME
;		struct_make
;
;	PURPSOE
;		create new structure
;
;	USAGE
;		r = struct_make('tag1',data1,'tag2',data2,....)
;
;		r = struct_make(['a','a.b.c','as.ed.ee'],0d)
;		r = strcut_make(['aa','bb'],[0,1],/extract) = struct_make('aa',0,'bb',1) 
;		r = struct_make(['aa','bb','cc'],list(3,'xx',indgen(10)),/extract)
;
;
;	INPUT
;		d1,d3,d5,... : tag names (string,array of string,
;		d2,d4,d6,... : data
;
;	KEYWORD
;		extract : 1-on-1 match of tage names and data elements
;
;	NOTE
;		improved from create_structure as it can handle structured tag names (e.g. 'AA.BB.CC')
;
;	AUTHOR
;		2012-06-08 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2013-09-25 added /extract
;-------------------------------------------------------------------------------

	function struct_make1,d1,d2
	
;-------------------------------------------------------------------------------

tg = n_elements(d1) eq 1 ? strsplit(str(d1),'.',/extract) : d1
rr = n_elements(tg) eq 1 ? create_struct(tg[0],d2) : create_struct(tg[0],struct_make1(tg[1:*],d2))

return,rr

end
;-------------------------------------------------------------------------------

	function struct_make2,d1,d2,extract=extract
	
;-------------------------------------------------------------------------------	
	
for itg=0L,n_elements(d1)-1 do rr = var_set(rr) ? struct_merge(rr,struct_make1(d1[itg],keyword_set(extract) ? d2[itg] : d2)) : struct_make1(d1[itg],keyword_set(extract) ? d2[itg] : d2)

return,rr

end
;-------------------------------------------------------------------------------	

	function struct_make,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,$
	         d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,d30,d31,d32,extract=extract
	
;-------------------------------------------------------------------------------	

if var_set(d1,d2)   then rr = var_set(rr) ? struct_merge(rr,struct_make2(d1,d2,extract=extract))   : struct_make2(d1,d2,extract=extract)
if var_set(d3,d4)   then rr = var_set(rr) ? struct_merge(rr,struct_make2(d3,d4))   : struct_make2(d3,d4)
if var_set(d5,d6)   then rr = var_set(rr) ? struct_merge(rr,struct_make2(d5,d6))   : struct_make2(d5,d6)
if var_set(d7,d8)   then rr = var_set(rr) ? struct_merge(rr,struct_make2(d7,d8))   : struct_make2(d7,d8)
if var_set(d9,d10)  then rr = var_set(rr) ? struct_merge(rr,struct_make2(d9,d10))  : struct_make2(d9,d10)
if var_set(d11,d12) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d11,d12)) : struct_make2(d11,d12)
if var_set(d13,d14) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d13,d14)) : struct_make2(d13,d14)
if var_set(d15,d16) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d15,d16)) : struct_make2(d15,d16)
if var_set(d17,d18) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d17,d18)) : struct_make2(d17,d18)
if var_set(d19,d20) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d19,d20)) : struct_make2(d19,d20)
if var_set(d21,d22) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d21,d22)) : struct_make2(d21,d22)
if var_set(d23,d24) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d23,d24)) : struct_make2(d23,d24)
if var_set(d25,d26) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d25,d26)) : struct_make2(d25,d26)
if var_set(d27,d28) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d27,d28)) : struct_make2(d27,d28)
if var_set(d29,d30) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d29,d30)) : struct_make2(d29,d30)
if var_set(d31,d32) then rr = var_set(rr) ? struct_merge(rr,struct_make2(d31,d32)) : struct_make2(d31,d32)

return,rr

end
