;-------------------------------------------------------------------------------
;	NAME
;		struct_list
;
;	PURPOSE
;		to convert a struct to list data type
;	
;	USAGE
;		rr = struct_list(s1[,otag=tag])
;
;	INPUT
;		s1 : structure
;
;	OUTPUT
;		otag : tag names returned
;
;	AUTHOR
;		2013-09-25 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function struct_list,s1,otag=tg
	
;-------------------------------------------------------------------------------

tg = struct_tag(s1)
rr = list()

for itg=0L,n_elements(tg)-1 do rr.add,struct_read(s1,tg[itg])

return,rr
end
