;-------------------------------------------------------------------------------
;	NAME
;		struct 
;
;	PURPOSE
;		IDL function to handle structure
;
;	USAGE
;		if struct(/set,struct[,'tag']) then
;		data    = struct(/read,struct,'tag')
;		struct2 = struct(/write,struct,'tag',data)
;		struct  = struct(/make,'tag',data)
;		tag     = struct(/tag,struct)
;		struct3 = struct([/add_new|/update|/merge],struct1,struct2)
;
;	INPUT		
;		struct : structure
;		tag    : tag name ('TAG1.TAG2' or 'TAG1 TAG2')
;		
;	KEYWORD
;		set      : to check if a var is structure or has given tag name
;		make     : to make new structure
;		read     : to read data for given tag name
;		write    : overwrite data to a structure
;		tag      : read tag names
;		update   : overwrite data from struct2 if struct1 has same tag name
;		add_new  : add data from struct2 if struct1 does not have same tag name
;		merge    : update and add new
;		retrieve : read data of given tags, and return then in string format
;		file     : read structure from a file
;		reform   : reform structure
;		extract  : extract given tag names only
;
;	AUTHOR
;		2008-03-17 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2008-06-19 added /file /reform
;		2008-07-15 added /extract
;		2011-09-15 added /initiate
;-------------------------------------------------------------------------------

	function struct,data1,data2,data3,data4,data5,data6,data7,data8,$
	         data9,data10,data11,data12,data13,data14,data15,data16,$
	         set=set,make=make,read=read,write=write,tag=tag,$
	         update=update,add_new=add_new,merge=merge,retrieve=retrieve,$
	         file=file,reform=reform,extract=extract,regroup=regroup,initiate=initiate
				 
;-------------------------------------------------------------------------------
				 				 
case 1 of

	keyword_set(set) : begin
	
		if n_tags(data1) eq 0 then return,0B
		
		case n_params() of
		
			1 : return,n_tags(data1) ne 0 
			2 : tag = str(data2)
			3 : tag = str(data2,data3,/join)
			4 : tag = str(data2,data3,data4,/join)
			5 : tag = str(data2,data3,data4,data5,/join)
			6 : tag = str(data2,data3,data4,data5,data6,/join)
			7 : tag = str(data2,data3,data4,data5,data6,data7,/join)
			8 : tag = str(data2,data3,data4,data5,data6,data7,data8,/join)
			
			else : message,'[USAGE] STRUCTURE_SET(STRUCT,TAG1,...,TAG6)'
		
		endcase
		
		if n_elements(tag) eq 1 then tag = strsplit(tag,' .',/extract)
		
		x = where(str(/up,tag_names(data1)) eq str(/up,tag[0]),nx)
		
		if n_elements(tag) eq 1 then if nx eq 1 then return,1B else return,0B $
		                        else if nx eq 1 then return,struct(/set,data1.(x),tag[1:*]) else return,0B						
	
		end

		;...........................................................................
		
	keyword_set(extract) : begin
	
		if n_elements(data2) eq 1 then tag = strsplit(data2,/extract) else tag = data2
		
		for itag=0L,n_elements(tag)-1 do begin
		
			if var_set(result) then result = struct(/merge,result,struct(/make,tag[itag],struct(/read,data1,tag[itag]))) $
			                   else result = struct(/make,tag[itag],struct(/read,data1,tag[itag])) 
				
		endfor
		
		return,result
	
		end		
		
		;...........................................................................

	keyword_set(retrieve) : begin
	
		if n_elements(data2) eq 1 then tag = strsplit(data2,/extract) else tag = data2
		
		ndata = n_elements(tag)
				
		result = strarr(ndata)
		
		for idata=0L,ndata-1 do result[idata] = strjoin(str(struct(/read,data1,tag[idata])),' ')
				
		return,result
	
		end		
		
		;...........................................................................
		
	keyword_set(read) : begin
	
		na = var_set(data3) ? data3 : 0B
	
		if n_tags(data1) lt 1 then return,na
	
		if n_elements(data2) eq 1 then tag = strsplit(data2,' .',/extract) else tag = data2
		
		x = where(tag_names(data1) eq str(/up,tag[0]),nx)
		
		if nx ne 1 then return,na
		
		if n_elements(tag) eq 1 then return,data1.(x) $
		                        else return,struct(/read,data1.(x),tag[1:*])
	
		end		
		
		;...........................................................................
				
	keyword_set(write) : begin
	
		struct1 = data1
		tag1    = tag_names(struct1)		
		tag2    = str(/up,data2)
		value2  = data3
		
		if n_elements(tag2) eq 1 then tag2 = strsplit(tag2,' .',/extract)
					
		x = where(tag1 eq tag2[0],nx)
										
		if nx eq 0 then begin
							
			result = create_struct(struct1,struct(/make,tag2,value2))
		
		endif else begin
		
			if n_elements(tag2) eq 1 then begin
			
				for itag1=0L,n_elements(tag1)-1 do begin
			
					result = var_set(result) ? create_struct(result,tag1[itag1],itag1 eq x ? value2 : struct1.(itag1)) $
					                         : create_struct(tag1[itag1],itag1 eq x ? value2 : struct1.(itag1))
					
				endfor	
			
			endif else begin
			
				for itag1=0L,n_elements(tag1)-1 do begin
				
					result = var_set(result) ? create_struct(result,tag1[itag1],itag1 eq x ? struct(/write,struct1.(itag1),tag2[1:*],value2) : struct1.(itag1)) $
					                         : create_struct(tag1[itag1],itag1 eq x ? struct(/write,struct1.(itag1),tag2[1:*],value2) : struct1.(itag1))
				
				endfor
			
			endelse
		
		endelse
		
		return,result
	
		end		
						
	keyword_set(make) : begin
				
		if n_elements(data1) eq 1 then tag = strsplit(data1,' .',/extract) else tag = data1
		if n_elements(tag)   eq 1 then result = create_struct(tag[0],data2) $
		                          else result = create_struct(tag[0],struct(/make,tag[1:*],data2))
															
		return,result															
	
		end
		
	keyword_set(initiate) : begin
			
		if var_set(data1,data2)   then for itag=0L,n_elements(data1)-1  do if var_set(data2)  then result = var_set(result) ? struct(/merge,result,struct(/make,data1[itag],data2))   : struct(/make,data1[itag],data2)
		if var_set(data3,data4)   then for itag=0L,n_elements(data3)-1  do if var_set(data4)  then result = var_set(result) ? struct(/merge,result,struct(/make,data3[itag],data4))   : struct(/make,data3[itag],data4)
		if var_set(data5,data6)   then for itag=0L,n_elements(data5)-1  do if var_set(data6)  then result = var_set(result) ? struct(/merge,result,struct(/make,data5[itag],data6))   : struct(/make,data5[itag],data6)
		if var_set(data7,data8)   then for itag=0L,n_elements(data7)-1  do if var_set(data8)  then result = var_set(result) ? struct(/merge,result,struct(/make,data7[itag],data8))   : struct(/make,data7[itag],data8)	
		if var_set(data9,data10)  then for itag=0L,n_elements(data9)-1  do if var_set(data10) then result = var_set(result) ? struct(/merge,result,struct(/make,data9[itag],data10))  : struct(/make,data9[itag],data10)
		if var_set(data11,data12) then for itag=0L,n_elements(data11)-1 do if var_set(data12) then result = var_set(result) ? struct(/merge,result,struct(/make,data11[itag],data12)) : struct(/make,data11[itag],data12)
		if var_set(data13,data14) then for itag=0L,n_elements(data13)-1 do if var_set(data14) then result = var_set(result) ? struct(/merge,result,struct(/make,data13[itag],data14)) : struct(/make,data13[itag],data14)
		if var_set(data15,data16) then for itag=0L,n_elements(data15)-1 do if var_set(data16) then result = var_set(result) ? struct(/merge,result,struct(/make,data15[itag],data16)) : struct(/make,data15[itag],data16)
																									
		return,var_set(result) ? result : 0B
	
		end						
		
	keyword_set(tag) : begin
			
		ntag = n_tags(data1)
		
		if ntag gt 0 then begin
		
			name = tag_names(data1)
			
			for itag=0L,ntag-1 do begin
			
				result = var_set(result) ? [result,name[itag]+' '+struct(/tag,data1.(itag))] $
				                         : [name[itag]+' '+struct(/tag,data1.(itag))]
			
			endfor
		
		endif else result = ''
		
		return,result
	
		end
		
		;...........................................................................
			
	keyword_set(add_new) : begin
		
		tag1 = struct(/tag,data1)
		tag2 = struct(/tag,data2)
			
		result = data1
						
		for itag2=0L,n_elements(tag2)-1 do begin
									
			x = where(tag1 eq tag2[itag2],nx)
								
			if nx eq 0 then result = struct(/write,result,tag2[itag2],struct(/read,data2,tag2[itag2]))
																										 			
		endfor
			
		return,result
													
		end
			
		;...........................................................................
			
	keyword_set(update) : begin
		
		tag1 = struct(/tag,data1)
		tag2 = struct(/tag,data2)
			
		result = data1
			
		for itag2=0L,n_elements(tag2)-1 do begin
			
			x = where(tag1 eq tag2[itag2],nx)
				
			if nx ne 0 then result = struct(/write,result,tag2[itag2],struct(/read,data2,tag2[itag2]))
			
		endfor
		
		return,result
	
		end	
					
		;...........................................................................
		
	keyword_set(merge) : begin
		
		if ~keyword_set(data1) and struct(/set,data2) then return,data2
		if ~keyword_set(data2) and struct(/set,data1) then return,data1		

		tag2 = struct(/tag,data2)
			
		result = data1
			
		for itag2=0L,n_elements(tag2)-1 do begin
			
			result = struct(/write,result,tag2[itag2],struct(/read,data2,tag2[itag2]))
			
		endfor
			
		return,result
				
		end			
			
		;...........................................................................
			
	keyword_set(file) : begin
	
		if file_test(data1) then begin
			
			data = rd_text(data1)
				
			for idata=0L,n_elements(data)-1 do begin
				
				line = strsplit(data[idata],/extract)
				head = strsplit(line[0],'/',/extract)					
				body = n_elements(line) gt 1 ? strjoin(line[1:*],' ') : ''
				type = 'S'
					
				if n_elements(head) ne 1 then begin & type = head[1]  &	head = head[0] & endif										
				if strpos(body,',') eq -1 then body = strsplit(body,/extract) else body = strsplit(body,',',/extract)								
					
				case str(/up,type) of
				
					'I'  : body = fix(body)							
					'F'  : body = float(body)	
					'L'  : body = long(body)	
					'D'  : body = double(body)	
					'I'  : body = fix(body)	
					else :
				endcase							 
																		 			
				if head ne '' then begin
									
					if not var_set(result) then result = struct(/make,head,body) $
					                       else result = struct(/merge,result,struct(/make,head,body))
																 
				endif																 
				
			endfor
			
			return,result
			
		endif else begin
			
			return,0B
			
		endelse
	
		end			

		;...........................................................................
			
	keyword_set(reform) : begin
		
		tag   = tag_names(data1)
		ntag  = n_tags(data1)
		ndata = data2
			
		for itag=0L,ntag-1 do begin
			
			r = struct(/read,data1,tag[itag])			
			r = reform(r,[n_elements(r)/ndata,ndata])
				
			if var_set(result) then result = struct(/merge,result,struct(/make,tag[itag],reform(r[*,0]))) $
			                   else result = struct(/make,tag[itag],reform(r[*,0]))
			
		endfor
			
		result = replicate(result,ndata)
				
		for itag=0L,ntag-1 do result.(itag) = reform(data1.(itag),size(result.(itag),/dim))
								
		return,result
							
		end			
		
	keyword_set(regroup) : begin
	
		if ~struct(/set,data1) and ~struct(/set,data2) then return,0B
		if ~struct(/set,data1) then return,data2
		if ~struct(/set,data2) then return,data1
			
		var1 = tag_names(data1)
		var2 = tag_names(data2)
		var3 = var1[[index(var1,var2,/contain,count=n)]]
		
		data = struct(/merge,data1,data2)
		
		if n eq 0 then return,data
		
		for ivar=0L,n_elements(var3)-1 do begin
				
			str1 = struct(/read,data1,var3[ivar])
			str2 = struct(/read,data2,var3[ivar])
			
			value3 = grouping('total',[str1.value,str2.value],[str1.ind,str2.ind],ogroup=ind3)
			
			data = struct(/merge,data,struct(/make,var3[ivar],{ind:ind3,value:value3}))
				
		endfor
		
		return,data
	
		end		
				
endcase				 

end
