;-------------------------------------------------------------------------------
;	NAME
;		str_pos
;
;	PURPOSE
;		strpos with multi input
;
;	USAGE
;		rr = str_pos(str1,str2[,/contain,/point])
;
;	INPUT
;		str1,str2 : string arrays
;
;	KEYWORD
;		contain : return indices of str1 that has any of str2
;		point	: return indices of str1 which corresponds to each of str2
;
;	AUTHOR
;		2015-03-03 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function str_pos,dd1,dd2,contain=contain,point=point

;-------------------------------------------------------------------------------

rr = list()

case 1 of

	keyword_set(contain) : begin
	
		for i=0L,n_elements(dd2)-1 do rr.add,strpos(dd1,dd2[i]) 
		return,where(total(rr.toarray(/no_copy) ne -1,1) ne 0)
		end
	
	keyword_set(point) : begin
	
		for i=0L,n_elements(dd2)-1 do rr.add,(where(strpos(dd1,dd2[i]) ne -1))[0]						
		return,rr.toarray(/no_copy)	
		end
		
	else : 	begin
		
		for i=0L,n_elements(dd2)-1 do rr.add,strpos(dd1,dd2[i])
		return,rr
		end

endcase

end
