;-------------------------------------------------------------------------------

	pro sample_no2_omi_cmaq

;-------------------------------------------------------------------------------

sdir  = 'data'                                         ; data directory
file1 = file_search(sdir,'subset.t12z.conc.*.ncf')     ; CMAQ CONC file(s)
file2 = file_search(sdir,'subset.t12z.metcro3d.*.ncf') ; CMAQ METCRO3D file(s)
ii    = ii_m3(file1[0]) 
minfo = ii.minfo  ; domain information

cday   = 20130805 ; Target day
range  = [0,10]   ; colorbar range

aa = rd_no2_cmaq(cday,'omi',file1,file2,/show,winn=0,range=range)               ; CMAQ/AK
bb = rd_no2_cmaq(cday,'omi',file1,file2,/show,winn=1,/nokernel,range=range)     ; CMAQ/noKernel
cc = rd_no2_omi_temis(cday,minfo=minfo,/show,winn=2,range=range)                ; OMI
dd = rd_no2_omi_temis(cday,minfo=minfo,/show,winn=3,downscale=bb,range=range)   ; OMI/DS

end
