;-------------------------------------------------------------------------------
;	NAME
;		run_scr
;
;	PURPOSE
;		to run shell script at given directory
;
;	USAGE
;		run_scr,scr[,cd=dir]
;
;	INPUT
;		scr : script to run
;		cd  : directory to move
;
;	AUTHOR
;		2013-08-14 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	pro run_scr,list,cd=_cd
	
;-------------------------------------------------------------------------------

if var_set(_cd) then cd,_cd,current=ccd

file = './dn'
openw,lun,file,/get_lun
for i=0L,n_elements(list)-1 do printf,lun,list[i]
free_lun,lun
spawn,str(/join,'chmod 775',file)
spawn,file
file_delete,file,/allow_nonexistent

if var_set(ccd) then cd,ccd

end
