;-------------------------------------------------------------------------------
;	NAME
;		run_hysplit
;
;	PURPOSE
;		to run NOAA/ARL HYSPLIT
;
;	USAGE
;		out = rd_hys(tflag,nstep,lon,lat,alt)
;
;	INPUT
;		tflag : ending time step
;		nstep : trajectory duration
;		lon   : site longitude
;		lat   : site latitude
;		alt   : site altitude
;		type  : input data type ("gdas1","gdas0p5","rean")
;		odir  : output directory
;		vertical : vertical motion option. default is 4
;
;	NOTE
;		Hysplit executable should be linked in the working directory
;		
;		ln -s /data/aqf/hyunk/model/Hysplit/trunk/exec/hyts_std hys_exe 
;
;	AUTHOR
;		2015-02-19 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function run_hysplit,_tflag,nstep,_lon,_lat,_alt,$
	         read=read,renew=renew,oinfo=oinfo,_extra=_ex

;-------------------------------------------------------------------------------

vert = struct_read(_ex,'vertical',0)
type = struct_set(_ex,'file') ? 'arl' : struct_read(_ex,'type','gdas1')
exe  = 'hys_exe'

if ~file_test(exe) then message,'NO HYSPLIT execuatable linked: ln -s HYSPLIT_EXE hys_exe'

lon = ary(_lon,nx=(nalt=n_elements(_alt)))
lat = ary(_lat,nx=nalt)
alt = ary(_alt,ny=(nsite=n_elements(_lon)))

odir  = path_check(struct_read(_ex,'odir','./out'),/make)
ofile = path_check(odir,str(/join,del='.',type,str(/join,del='_',nsite,nalt,nstep,mean(lon),mean(lat),vert),_tflag,'hys'))

	;	
	
if file_renew(ofile,renew=renew) then begin

	;if ~var_set(file ) then file  = dn_hysplit_input(date(_tflag,nstep,/make),type)		
	
	file  = dn_hysplit_input(date(_tflag,nstep,/make),type,_extra=_ex)
	
	openw,lun,'CONTROL',/get_lun
	
	printf,lun,date(_tflag,'%y %m %d %H',/format)
	printf,lun,str(n_elements(lon))
	for i=0L,n_elements(lon)-1 do printf,lun,lat[i],lon[i],alt[i]
	printf,lun,str(nstep)
	printf,lun,str(vert)
	printf,lun,'10000.0'
	printf,lun,str(n_elements(file))

	for ifile=0l,n_elements(file)-1 do begin

		printf,lun,file_dirname(file[ifile])+'/'
		printf,lun,file_basename(file[ifile])
	
	endfor

	printf,lun,str(odir)+'/'
	printf,lun,str(file_basename(ofile))
	free_lun,lun
	
	run_scr,exe	

endif

	;
	
if keyword_set(read) then ofile = rd_hys(ofile,oinfo=oinfo)
	
return,ofile

end
