;-------------------------------------------------------------------------------
;	NAME
;		routine_copy
;
;	PURPOSE
;		IDL procedure to copy all subroutine belonging to given routine
;
;	USAGE
;		routine_copy,'routine_name'
;
;	INPUT
;		name : routine name
;		odir : output directory
;
;	KEYWORD
;		N/A
;
;	AUTHOR
;		2008-11-06 Hyun Cheol Kim 
;		2013-07-30 added routine_info_lib() to check IDL default library directory
;		           fixed /add
;-------------------------------------------------------------------------------

	pro routine_copy,name,odir=_odir,all=all
	
;-------------------------------------------------------------------------------

resolve_routine,name,/either
resolve_all,/continue_on_error

odir = path_check(/make,var_set(_odir) ? _odir : 'routines_'+str(name))

	; copy procedures

list = routine_info()

for i=0L,n_elements(list)-1 do begin

	info = routine_info(list[i],/source)	
	skip = (file_dirname(info.path) eq routine_info_lib() and ~keyword_set(all)) or (str(/up,info.path) eq '')
	
	message,/info,str(/join,(keyword_set(skip) ? '[SKIP]' : '[COPY]'),info.path)
	if keyword_set(skip) then continue
	
	file_copy,info.path,path_check(odir,file_basename(info.path)),/overwrite
			
endfor

	; copy functions

list = routine_info(/functions)

for i=0L,n_elements(list)-1 do begin

	info = routine_info(list[i],/function,/source)
	skip = (file_dirname(info.path) eq routine_info_lib() and ~keyword_set(all)) or (str(/up,info.path) eq '')
	
	message,/info,str(/join,(keyword_set(skip) ? '[SKIP]' : '[COPY]'),info.path)
	if keyword_set(skip) then continue
	
	if str(info.path) ne '' then file_copy,info.path,path_check(odir,file_basename(info.path)),/overwrite
		
endfor

end
