;-------------------------------------------------------------------------------
;	NAME
;		rd_shp
;
;	PURPOSE
;		IDL function to read GIS shape file
;
;	USAGE
;		r = rd_shp(file,/info)
;		r = rd_shp(file,attr_name=attr_name)
;		r = rd_shp(file,attr_name=attr_name,attr_str=attr_str)
;
;	INPUT
;		file      : shape file name
;		attr_name : attribute name to read ("ATTRIBUTE_0")
;		attr_str  : attribute name to match 
;
;	KEYWORD
;		info : return shape file information
;
;	AUTHRO
;		2009-07-21 Hyun Cheol Kim (hyuncheol.kim@gmail.com,hkim2@mail.uh.edu)
;-------------------------------------------------------------------------------

	function rd_shp,file,info=info,attr=attr,entity=entity,oinfo=oinfo,$
	         data=data,name=name,bounds=bounds,combine=combine,quiet=quiet
	
;-------------------------------------------------------------------------------	

if ~file_test(file) then message,str(/join,'NO FILE!',file)
	
case 1 of

	var_set(info) : begin
	
		myshape = obj_new('IDLffShape',file)		
		message,/info,str(/join,'READ',file)		
		myshape->IDLffShape::GetProperty,N_ENTITIES=n_entities,ENTITY_TYPE=entity_type,N_ATTRIBUTES=n_attributes,ATTRIBUTE_NAMES=attribute_names,ATTRIBUTE_INFO=attribute_info

		if ~var_set(quiet) then begin
				
			help,n_entities,entity_type,n_attributes,attribute_names,attribute_info
			help,attribute_info,/str			
			for iattr=0L,n_attributes-1 do print,str(/join,'['+str(iattr,digit=strlen(str(n_attributes-1)))+']',attribute_names[iattr])
		
		endif
	
		OBJ_DESTROY,myshape
		
		return,{n_entities:n_entities,entity_type:entity_type,n_attributes:n_attributes,attribute_names:attribute_names,attribute_info:attribute_info}				
		end
		
	var_set(file,attr) : begin
	
		message,/info,str(/join,'READ',file)	
		myshape = obj_new('IDLffShape',file)				
		myshape->IDLffShape::GetProperty,N_ENTITIES=n_entities,ENTITY_TYPE=entity_type,N_ATTRIBUTES=n_attributes,ATTRIBUTE_NAMES=attribute_names,ATTRIBUTE_INFO=attribute_info
														
		for ient=0L,n_entities-1 do begin
					
			att=myshape->IDLffShape::GetAttributes(ient)
				
			if ~var_set(rr) then rr = replicate(att,n_entities)			
			rr[ient] = att
						
		endfor	
	
		OBJ_DESTROY,myshape
		
		if ~var_set(rr) then return,!null
															
		rr = struct_retag(rr,rename=(_rename=idl_validname(attribute_names,/convert_all)))
		
		oinfo = {attr_name:_rename}
														
		if var_set(attr,/keyword_only) then return,rr else return,struct_retag(rr,tag=attr)
		end
		
	var_set(bounds) : begin
		
		message,/info,str(/join,'READ',file)	
		myshape = obj_new('IDLffShape',file)
		myshape->IDLffShape::GetProperty,N_ENTITIES=n_entities,ENTITY_TYPE=entity_type,N_ATTRIBUTES=n_attributes,ATTRIBUTE_NAMES=attribute_names,ATTRIBUTE_INFO=attribute_info
				
		rr = dblarr(8,n_entities)		
									
		for ient=0L,n_entities-1 do begin
					
			ent = myshape->IDLffShape::GetEntity(ient)																		
			rr[*,ient] = ent.bounds			
			myshape->DestroyEntity,ent
								
		endfor	
	
		OBJ_DESTROY,myshape
		
		return,rr		
		end
		
	keyword_set(combine) : begin
	
		myshape = obj_new('IDLffShape',file)
		myshape->IDLffShape::GetProperty,N_ENTITIES=n_entities,ENTITY_TYPE=entity_type,N_ATTRIBUTES=n_attributes,ATTRIBUTE_NAMES=attribute_names,ATTRIBUTE_INFO=attribute_info
			
		vert = !null
		part = !null
		attr = !null     
		if ~var_set(entity) then entity = lindgen(n_entities)

		for ient=0L,n_elements(entity)-1 do begin
		
			str_progress,ient,n_elements(entity),message='Combining all geoinfo'

			ent  = myshape->IDLffShape::GetEntity(entity[ient])				
			att  = myshape->IDLffShape::GetAttributes(entity[ient])

			part = [part,n_elements(vert)/2+*ent.parts]
			vert = [[vert],[*ent.vertices]] 	
			attr = [attr,create_struct(att,{parts_start:n_elements(vert)/2,entity:entity[ient]})]
			
		endfor

		part = [part,n_elements(vert)/2-1]

		return,{vertices:vert,parts:part,attribute:attr,n_entities:n_elements(entity)}
		end
		
	var_set(file,entity) : begin
		
		myshape = obj_new('IDLffShape',file)
						
		message,/info,str(/join,'READ!',file,'ENTITY',entity)
	
		attr = myshape -> IDLffShape::GetAttributes(entity)	
		ent  = myshape -> IDLffShape::GetEntity(entity)
			
		case ent.shape_type of
			
			1 : r = {attr:attr}																						
			3 : begin
				
				lon = reform((*ent.vertices)[0,*])
				lat = reform((*ent.vertices)[1,*])
				cut = [*ent.parts,n_elements(lon)-1]
					
				if min(lon) ge -360 and max(lon) le 360 and min(lat) ge -90 and max(lat) le 90 then ll = 1 else ll = 0
					
				if keyword_set(ll) then  r = {attr:attr,lon:lon,lat:lat,cut:cut,ll:ll} else r = {attr:attr,ll:ll}
					
				end
			
			5 : begin
								
				lon = reform((*ent.vertices)[0,*])
				lat = reform((*ent.vertices)[1,*])
				cut = [*ent.parts,n_elements(lon)-1]
					
				if min(lon) ge -360 and max(lon) le 360 and min(lat) ge -90 and max(lat) le 90 then ll = 1 else ll = 0	
					
				if keyword_set(ll) then  r = {attr:attr,lon:lon,lat:lat,cut:cut,ll:ll} else r = {attr:attr,ll:ll}
			
				end
								
		endcase
						
		OBJ_DESTROY,myshape
			
		return,r			
		end
		
	else : message,str(/join,'[USAGE] r = rd_shp(file[,attr_name,attr_str,entity])')

endcase	
	
end
