
;-------------------------------------------------------------------------------

	function rd_no2_omi_temis_file1,file,oinfo=oinfo

;-------------------------------------------------------------------------------

if file_test(file[0]) then message,/info,str(/join,'READ',file[0])

nan = !values.f_nan
res = h5_parse(file,/read_data)
res = res.HDFEOS.SWATHS.DOMINONO2

vcdtrop = res.data_fields.troposphericverticalcolumn._data * res.data_fields.troposphericverticalcolumn.scalefactor._data[0]
a_lev   = res.DATA_FIELDS.TM4PRESSURELEVELA._data
b_lev   = res.DATA_FIELDS.TM4PRESSURELEVELB._data
ndata   = n_elements(vcdtrop)
nlev    = n_elements(a_lev)

rr   = replicate(struct_make(['date','time'],'',['lon','lat','vcdtrop','fltrop','clfrac','psurf','amf','amftrop'],nan,['loncorn','latcorn'],fltarr(4),['kernel'],replicate(nan,nlev)),size(vcdtrop,/dim))

rr.vcdtrop = vcdtrop/1e15
rr.amf     = res.data_fields.airmassfactor._data * res.data_fields.airmassfactor.scalefactor._data[0]
rr.amftrop = res.data_fields.airmassfactortropospheric._data * res.data_fields.airmassfactortropospheric.scalefactor._data[0]
rr.fltrop  = res.data_fields.troposphericcolumnflag._data
rr.lat     = res.geolocation_fields.latitude._data
rr.lon     = res.geolocation_fields.longitude._data
rr.clfrac  = res.data_fields.CloudFraction._data * res.data_fields.CloudFraction.scalefactor._data[0]
rr.psurf   = res.data_fields.tm4surfacepressure._data * res.data_fields.tm4surfacepressure.scalefactor._data[0]*100.

rr.latcorn = transpose(res.geolocation_fields.latitudecornerpoints._data,[2,0,1])
rr.loncorn = transpose(res.geolocation_fields.longitudecornerpoints._data,[2,0,1])
rr.kernel  = transpose(res.data_fields.averagingkernel._data * res.data_fields.averagingkernel.scalefactor._data[0],[2,0,1])

rr = data_check(rr,rr.fltrop eq 0)

oinfo = {a_lev:a_lev,b_lev:b_lev}

return,rr
end
;-------------------------------------------------------------------------------

	function rd_no2_omi_temis_dayfile,cday,lon360=lon360,oinfo=oinfo,_extra=_ex

;-------------------------------------------------------------------------------

sdir = path_check(getenv('HOME'),'data','temis','omi','no2','daily',/make)
save = path_check(sdir,str(/join,del='.','no2vcd','omi','temis',cday,'sav'))

if file_renew(save,_extra=_ex) then begin

	file = dn_no2_omi_temis(cday)
	if ~keyword_set(file) then return,!null
		
	for ifile=0L,n_elements(file)-1 do begin
	
		rr1 = rd_no2_omi_temis_file1(file[ifile],oinfo=oinfo)
		if ~keyword_set(rr1) then continue
	
		rr = var_set(rr) ? [rr,rr1] : rr1
	
	endfor
	
	if ~var_set(rr) then return,!null
	
	message,/info,str(/join,'SAVE',save)
	save,filename=save,rr,oinfo

endif else begin

	message,/info,str(/join,'READ',save)
	restore,save

endelse

if keyword_set(lon360) then begin
		
	xx = where(rr.lon lt 0.,nxx)
	if nxx gt 0 then rr[xx].lon = (rr[xx].lon+360.) mod 360.				
	if nxx gt 0 then rr[xx].loncorn = (rr[xx].loncorn+360.) mod 360.										
					
endif else begin

	xx = where(rr.lon gt 180.,nxx)					
	if nxx gt 0 then rr[xx].lon = ((rr[xx].lon+180.) mod 360.)-180.
	if nxx gt 0 then rr[xx].loncorn = ((rr[xx].loncorn+180.) mod 360.)-180.	
	
endelse

return,rr
end
