;-------------------------------------------------------------------------------

	function rd_no2_omi_temis_ak,cday,domain=domain,minfo=minfo,oinfo=info,_extra=_ex

;-------------------------------------------------------------------------------

if min(strlen(str(cday)),max=mx) ne 8 or mx ne 8 then message,'CDAY=YYYYMMDD'
;if str(cday) lt '20130806' then return,0B

max_size = struct_read(_ex,'max_size',1000.)
cld_frac = struct_read(_ex,'max_cloud',0.4)

minfo = aqm_grid(domain=domain,minfo=minfo,omid=mid)
sdir  = path_check(getenv('HOME'),'data','temis','omi','no2','ak',/make)
save  = path_check(sdir,str(/join,del='.','no2','omi','ak',mid,str(/join,del='-',long(max_size),string(cld_frac,format='(F3.1)')),cday))

if file_renew(save,_extra=_ex) then begin

	if ~keyword_set((rr=rd_no2_omi_temis_dayfile(cday,oinfo=rri))) then return,!null				
	if ~keyword_set((rr=data_check(rr,rr.clfrac lt cld_frac,ina=0b))) then return,!null
	
	limit = aqm_grid_limit(domain=domain,minfo=minfo)
	limit = [min(limit[0,*]),min(limit[1,*]),max(limit[0,*]),max(limit[1,*])]
	
	if ~keyword_set((rr=data_check(rr,rr.lon ge limit[0]-1 and rr.lon le limit[2]+1 and rr.lat ge limit[1]-1 and rr.lat lt limit[3]+1,ina=0b))) then return,!null
				
	pixel_size = map_3points((tlon=(rr.loncorn)[[0,1,3,2,0],*]),(rr.latcorn)[[0,1,3,2,0],*])*2./1e6	
	if struct_set(_ex,'pixel_size') then return,pixel_size
		
	if ~keyword_set((rr=data_check(rr,pixel_size le max_size and max(tlon,dim=1,min=tlon_mn)-tlon_mn lt 180.,ina=0b))) then return,!null
		
	ps = aqm_regrd((rr.loncorn)[[0,1,3,2,0],*],(rr.latcorn)[[0,1,3,2,0],*],rr.psurf,domain=domain,minfo=minfo,/avg,finfo=finfo)
	aa = aqm_regrd((rr.loncorn)[[0,1,3,2,0],*],(rr.latcorn)[[0,1,3,2,0],*],rr.amf,domain=domain,minfo=minfo,/avg,finfo=finfo)
	at = aqm_regrd((rr.loncorn)[[0,1,3,2,0],*],(rr.latcorn)[[0,1,3,2,0],*],rr.amftrop,domain=domain,minfo=minfo,/avg,finfo=finfo)

	kn = make_array([minfo.nx,minfo.ny,(nlev=n_elements(rri.a_lev))],value=!values.f_nan)

	for ilev=0L,nlev-1 do begin
		str_progress,ilev,nlev,message='REGRID kernel'
		kn[*,*,ilev] = aqm_regrd((rr.loncorn)[[0,1,3,2,0],*],(rr.latcorn)[[0,1,3,2,0],*],rr[*].kernel[ilev],domain=domain,minfo=minfo,/avg,finfo=finfo)
	endfor
	
	rr = {psurf:ps,amf:aa,amftrop:at,kernel:kn,info:rri}

	message,/info,str(/join,'SAVE',save)
	save,filename=save,rr

endif else begin

	message,/info,str(/join,'READ',save)
	restore,save

endelse
		
return,rr
end
