;-------------------------------------------------------------------------------
;	NAME
;		rd_ncdf
;
;	PURPOSE
;		quick read of ncdf file
;
;	USAGE
;		r = rd_ncdf(file[,opt,var=var,ivar=ivar][,oinfo=oinfo])
;
;	INPUT
;		file : ncdf file name
;		opt  : var or ivar
;		var  : variable name to read
;		ivar : variable number to red
;
;	OUTPUT
;		oinfo : return ncdf info
;
;	AUTHOR
;		2009-12-03 Hyun Cheol Kim (hyun.kim@noaa.gov)
;
;-------------------------------------------------------------------------------

	function rd_ncdf,file,opt,var=var,ivar=ivar,oinfo=info,quiet=quiet
	
;-------------------------------------------------------------------------------	

if ~file_test(file[0]) then message,str(/join,'NO FILE',file[0])

if var_set(opt) then if size(opt,/type) eq 7 then var = opt else ivar = opt

cdf_id = ncdf_open(file[0])

if var_set(var)  then ivar = ncdf_varid(cdf_id,var)
if var_set(ivar) then info = ncdf_varinq(cdf_id,ivar)

ncdf_varget,cdf_id,ivar,data

ncdf_close,cdf_id

if ~keyword_set(quiet) then help,info,/str
if ~keyword_set(quiet) then help,data

return,data

end
