;-------------------------------------------------------------------------------
;	NAME
;		rd_hys
;
;	PURPOSE
;		ro read HYSPLIT output
;
;	USAGE
;		rr = rd_hys_file(file[,/reform][,oinfo=])
;
;	INPUT
;		file : HYSPLIT txt output
;
;	KEYWORD
;		reform : reform result to [nsite,nalt]
;
;	OUTPUT
;		oinfo : returns additional information
;
;	AUTHOR
;		2015-02-20 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function rd_hys,file,oinfo=oinfo,reform=reform

;-------------------------------------------------------------------------------

nan = !values.f_nan
dd = rd_text(file[0],/column)
n1 = fix(dd[0,0])
n2 = fix(dd[0,n1+1])
xsite = idx(dd[5,n1+2:n1+1+n2]+','+dd[4,n1+2:n1+1+n2],/self,oself=site)
xalt  = idx(float(dd[6,n1+2:n1+1+n2]),/self,oself=alt)
oinfo = {type:str(dd[1,n1+1]),ndata:n2,site:site,xsite:xsite,nsite:n_elements(site),alt:alt,xalt:xalt,nalt:n_elements(alt)}

	;

dd = dd[*,n1+n2+3:*]

time  = str(dd[2,*],digit=2)+str(dd[3,*],digit=2)+str(dd[4,*],digit=2)+str(dd[5,*],digit=2)
time  = (['20','19'])[value_locate([0,50],strmid(time,0,2))]+time
tflag = date(min(time),max(time),/make)
ntime = n_elements(tflag)
xtime = idx(tflag,time,/point)

if keyword_set(reform) then begin

	rr = replicate({lon:nan,lat:nan,alt:nan},[oinfo.nsite,oinfo.nalt,ntime])

	rr[xsite[(xx=fix(dd[0,*])-1)],xalt[xx],xtime].lon = float(dd[10,*])
	rr[xsite[xx],xalt[xx],xtime].lat = float(dd[9,*])
	rr[xsite[xx],xalt[xx],xtime].alt = float(dd[11,*])

endif else begin

	rr = replicate({lon:nan,lat:nan,alt:nan},[n2,ntime])

	rr[(xx=fix(dd[0,*])-1),xtime].lon =  float(dd[10,*])
	rr[xx,xtime].lat =  float(dd[9,*])
	rr[xx,xtime].alt =  float(dd[11,*])

endelse

oinfo = struct_merge(oinfo,{tflag:tflag,ntime:ntime})

return,rr
end
