;-------------------------------------------------------------------------------
;	NAME
;		plot_z
;	
;	PURPOSE
;		to open and close z-buffer model
;
;	USAGE
;		plot_z,/open
;		plot_z,/close[,image=][,png=
;
;	INPUT
;
;	
;	KEYWORD
;		open  : start z-mode
;		close : end z-mode
;		hide  : do not show image on screen
;		winn  : window number
;
;	OUTPUT
;		d_name : current display name
;		image : screen capture image
;
;	AUTHOR	
;		2014-07-21 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------
	
	pro plot_z,open=_open,close=_close,d_name=d_name,image=image,true=true,_extra=_ex

;-------------------------------------------------------------------------------

case 1 of

	keyword_set(_open) : begin
	
		d_name = !d.name
		set_plot,'z',/copy
		if struct_set(_ex,['xsize','ysize']) then device,set_resolution=[_ex.xsize,_ex.ysize]
		device,z_buffer=struct_read(_ex,'z_buffer',0)
		end
		
	keyword_set(_close) : begin
	
		if arg_present(image) then image = tvrd(true=true)
		
		if struct_set(_ex,'png') then begin
		
			tvlct,r,g,b,/get
			message,/info,str(/join,'SAVE',(png=file_name(_ex.png,/png,/sdir)))						
			write_png,png,var_set(image,ina=tvrd(true=ture)),r,g,b		
		endif
	
		device,/close,z_buffer=1
		set_plot,var_set(d_name,ina='x')
		
		if ~struct_read(_ex,'hide',0) then begin
		
			dim = size(image,/dim)
			if !d.window eq -1 or !d.x_size ne dim[0] or !d.y_size ne dim[1] then window,struct_read(_ex,'winn',0),xsize=dim[0],ysize=dim[1]
			tv,image
		
		endif
	
		end	

endcase

end
