;-------------------------------------------------------------------------------
;	NAME
;		plot_wmap
;
;	PURPOSE
;		To overplot weather map 
;
;	USAGE
;		plot_wmap,type,tflag
;
;	INPUT
;		type : 'us' or 'kma'
;		tflag : YYYYMMDDHH
;
;	AUTHOR
;		2014-04-09 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	pro plot_wmap,type,tflag,_extra=_ex

;-------------------------------------------------------------------------------

case str(/low,type) of

	'us' : begin
	
		file = dn_wmap_usfntsfc(tflag)
		save = path_check(getenv('HOME'),'data','georef',str(/join,del='.','georef','wmap_usfntsfc','sav'))
		
		if ~file_test(file) then return
		if ~file_test(save) then return else restore,save
		
		color1 = ['red','red','blue','purple']
		color2 = ['gray','red','blue','purple']
		depth  = [40,5,5,5]
		rr = gif_extract_color(file,color1,depth,odim=dim)
					
		end
		
	'kma' : begin
	
		file = dn_wmap_kma(tflag)
		save = path_check(getenv('HOME'),'data','georef',str(/join,del='.','georef','wmap_kmasfc3','sav'))
						
		if ~file_test(file) then return
		if ~file_test(save) then return else restore,save
		
		color1 = ['blue','red']
		color2 = color1
		depth  = [40,5]
		rr = gif_extract_color(file,color1,depth,odim=dim)
			
		end	

endcase

	;

psym = struct_read(_ex,'psym',3)
symsize = struct_read(_ex,'symsize',1.)

for icolor=0L,n_elements(color1)-1 do begin

	plots,info.lon[where(rr[*,*,icolor])],info.lat[where(rr[*,*,icolor])],color=color_load(/get,color2[icolor]),noclip=0,psym=psym,symsize=symsize

endfor

end
