;-------------------------------------------------------------------------------
;	NAME
;		plot_wind_barb
;
;	PURPOSE
;		plot wind barb
;
;	USAGE
;		plot_wind_barb,knot,angle,xp,yp[,scale=,color=]
;
;	INPUT
;		knot  : wind speed in know
;		angle : wind direction in angle
;		xp    : x position in device mode
;		yp    : y position in device mode
;		scale : wind barb size in device mode
;		color : wind barb color
;
;	KEYWORD
;
;	NOTE
;		rewritten from Dominik Brunner's wind_barb.pro
;
;		Be careful of WIND ANGLE!!! angle = 45 is toward NE not from NE
;		USE plot_wind for normal concept of wind direction
;
;	AUTHOR
;		2010-01-08 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	pro plot_wind_barb,k,_a,xp,yp,scale=scale,color=color,_extra=_ex

;-------------------------------------------------------------------------------

if ~ var_set(scale) then scale = 20

nk = min([n_elements(k),n_elements(_a),n_elements(xp),n_elements(yp)])

a = ( _a + 180 ) mod 360

if var_set(color) then color = array(color_load(/get,color),count=nk) else color = array(!p.color,count=nk)

for ik=0L,nk-1 do begin

	; rotation matrix
	
	mrot = reform([cos(-!dtor*a[ik]),sin(-!dtor*a[ik]),-sin(-!dtor*a[ik]),cos(-!dtor*a[ik])],[2,2])
	
	nflag  = fix(k[ik])/50
	nbarb1 = fix(k[ik]-nflag*50)/10
	nbarb2 = fix(k[ik]-nflag*50-nbarb1*10)/5
		
	if k[ik] gt 0 then begin
	
		orig = [0.,0.]
		epts = [0.,1.]		
		epts = orig+mrot#epts
		
		plots,xp[ik]+scale*[orig[0,0],epts[0,0]],yp[ik]+scale*[orig[1,0],epts[1,0]],color=color[ik],/device,_extra=_ex
		
			; pennant
		
		for i=0,nflag-1 do begin

			orig = mrot#[0.,1-i*0.2]
			flag = mrot#[[0,0.],[0.4,0.3],[0,0.2]]
						
			polyfill,xp[ik]+scale*(orig[0]+flag[0,*]),yp[ik]+scale*(orig[1]+flag[1,*]),color=color[ik],/fill,/device,_extra=_ex
				
		endfor
		
			; long barb
			
		for i=0,nbarb1-1 do begin

			orig = mrot#[0.,1-(nflag+i)*0.2]
			endp = orig+mrot#[0.4,0.3]
			
			plots,xp[ik]+scale*[orig[0],endp[0,0]],yp[ik]+scale*[orig[1],endp[1,0]],color=color[ik],/device,_extra=_ex
		
		endfor			
		
			; short barb
			
		yorig = -0.2*((nflag+nbarb1) eq 0) ; if no long bar or pennant
		
		for i=0,nbarb2-1 do begin

			orig = mrot#[0.,1-(nflag+nbarb1+i)*0.2+yorig]
			endp = orig+mrot#[0.2,0.15]
			
			plots,xp[ik]+scale*[orig[0],endp[0,0]],yp[ik]+scale*[orig[1],endp[1,0]],color=color[ik],/device,_extra=_ex
		
		endfor					
	
	endif

endfor

end
