;-------------------------------------------------------------------------------
;	NAME
;		plot_shp
;
;	PURPOSE
;		plot shape 
;
;	USAGE
;		plot_shp,file[,entity=arr][,/fill,/quiet][,_extra=_es]
;
;	INPUT
;		file   : shape file name
;		entity : entity index to plot. default is all entities
;		
;	KEYWORD
;		quiet : no verse display when reading shape file information
;
;	NOTE 	
;		accepts extra parameters for polyfill and plots
;
;	AUTHOR
;		2011-11-03 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2015-05-15 changed color option
;-------------------------------------------------------------------------------

	pro plot_shp,file,entity=entity,fill=fill,quiet=quiet,color=_color,_extra=_ex
	
;-------------------------------------------------------------------------------	
	
info   = ii_shp(file)
entity = var_set(entity,ina=lindgen(info.n_entities))
color  = ary(var_set(_color,ina=mir_cl(/get,'blue')),count=n_elements(entity))
bcolor = struct_read(_ex,'bcolor',mir_cl(/get,'slategray'))

myshape = obj_new('IDLffShape',file)
myshape->IDLffShape::GetProperty,N_ENTITIES=n_entities,ENTITY_TYPE=entity_type,N_ATTRIBUTES=n_attributes,ATTRIBUTE_NAMES=attribute_names,ATTRIBUTE_INFO=attribute_info

for i=0L,n_elements(entity)-1 do begin

	ient = entity[i]
	ent  = myshape->IDLffShape::GetEntity(ient)
		
	if ent.n_vertices le 1 then begin
	
		;oplot,ent.bound[0],ent.bound[1],psym=7
						
	endif else begin
		
	lon = reform((*ent.vertices)[0,*],/overwrite)
	lat = reform((*ent.vertices)[1,*],/overwrite)
	cut = [*ent.parts,n_elements(lon)]

	myshape->DestroyEntity,ent
			
	for icut=0L,n_elements(cut)-2 do begin
	
		case entity_type of
		
			1 : plot,lon[cut[icut]:cut[icut+1]-1],lat[cut[icut]:cut[icut+1]-1],color=color[i],_extra=_ex
			3 : plots,lon[cut[icut]:cut[icut+1]-1],lat[cut[icut]:cut[icut+1]-1],color=color[i],_extra=_ex
			
			5 : begin
			
				if keyword_set(fill) then polyfill,lon[cut[icut]:cut[icut+1]-1],lat[cut[icut]:cut[icut+1]-1],color=color[i],_extra=_ex			
				plots,lon[cut[icut]:cut[icut+1]-1],lat[cut[icut]:cut[icut+1]-1],color=bcolor,_extra=_ex
				end			
		
		endcase
				
	endfor
	
	endelse

endfor
		
OBJ_DESTROY,myshape
		
end
