;------------------------------------------------------------------------------
;	NAME
;		plot_ps
;
;	PURPOSE
;		support PS outputs
;
;	USAGE
;		plot_ps,/open,'output.ps'
;		...
;		plot_ps,/close	
;
;	INPUT
;		output  : output file name
;		png     : PNG output filename
;		density : image resolution for PNG 
;		xsize   : xsize in inch
;		ysize   : ysize in inch
;
;	KEYWORD
;		open  : start PS
;		close : close PS
;		png   : convert PS to PNG
;
;	AUTHOR
;		2010-08-18 Hyun Cheol Kim (hyun.kim@noaa.gov)
;------------------------------------------------------------------------------

	pro plot_ps,_output,open=open,close=close,ps=ps,png=png,density=density,$
	    xsize=xsize,ysize=ysize,hide=hide,d_name=d_name,winn=winn
	
;-------------------------------------------------------------------------------

output = file_name(var_set(_output,ina='1.ps'),/ps,/sdir)

case 1 of
	
	var_set(open) : begin
	
		d_name = !d.name
	
		if ~var_set(xsize) then xsize = 9
		if ~var_set(ysize) then ysize = float(xsize)/!d.x_vsize*!d.y_vsize
		
		set_plot,'ps'
		device,decomposed=0,color=1,bits_per_pixel=8
		!p.font=0
		device,filename=output,encapsulated=1,/helvetica,font_size=3
		device,xsize=xsize,ysize=ysize
		
		end
		
	var_set(close) : begin				

		device,/close
		set_plot,var_set(d_name,ina='x')
		!p.font = -1
						
		if var_set(png) and file_test(output) then begin
								
			message,/info,str(/join,'WRITE',(ofile=file_name(output,/png,/sdir)))
			spawn,str(/join,'convert -density',var_set(density,ina=254),output,ofile)
			
			if ~keyword_set(hide) then begin
			
				dim = size((image = read_png(ofile)),/dim)
				if !d.window eq -1 or !d.x_size ne dim[1] or !d.y_size ne dim[2] then window,var_set(winn,ina=0),xsize=dim[1],ysize=dim[2]
				tvimage,image
			
			endif
			
			if ~keyword_set(ps) then file_delete,output
		
		endif
		
	end
	
endcase	

end
