;-------------------------------------------------------------------------------
;	NAME
;		path_check
;
;	PURPOSE
;		IDL function to handle directory path
;
;	USAGE
;		r = dir(paht1,path2,...,path9[,file=file][,/set])
;
;	INPUT
;		path1-9 : path name string/array
;   
;	KEYWORD
;		make : make directory
;		uniq : return unique path string (combined)
;		set : check existency of directory and return the first available path
;		      if nothing is available, make one
;
;	AUTHOR
;		2005-12-11 Hyun Cheol Kim (hyun.kim@noaa.gov, hyuncheol.kim@gmail.com)
;		2008-10-23 added /set
;		2015-12-04 rewrote /uniq
;-------------------------------------------------------------------------------

	function path_check,_data1,_data2,_data3,_data4,_data5,_data6,_data7, $
	         _data8,_data9,set=set,make=make,uniq=uniq,remove=remove

;-------------------------------------------------------------------------------

case 1 of

	keyword_set(uniq) : begin
	
		if n_elements((aa=file_dirname(_data1))) eq 1 then return,strjoin(strsplit(aa,path_sep(),/extract),'-')		
		if strlen((hh=var_set(remove,ina=getenv('HOME')))) gt 0 then aa = data_check(aa,(xx = strpos(aa,hh)) ne -1,strmid(aa,transpose(xx)+strlen(hh)+1))
		aa = rd_text(aa,/column,del=path_sep())
		aa = (aa[*,0])[where(product(aa eq shift(aa,[0,1]),2) eq 1)]		
		return,strjoin(str(aa[0]) eq '' ? aa[1:*] : aa,'-')			
		end

	keyword_set(make) : begin
	
		odir = path_check(_data1,_data2,_data3,_data4,_data5,_data6,_data7,_data8,_data9)
		file_mkdir,odir
		return,odir	
		end

	keyword_set(set) : begin
	
		sdir = path_check(_data1,_data2,_data3,_data4,_data5,_data6,_data7,_data8,_data9)
		
		ok   = where(file_test(sdir,/dir) eq 1,nok)
		
		if nok gt 0 then begin
		
			return,sdir[ok[0]] 
			
		endif else begin
										
			spawn,'whoami',user
				
			if user eq 'hkim' then file_mkdir,sdir[0] else message,str(/join,'[NO directory found]',sdir)															
						
		endelse	
	
		end
		
	else : begin		

		dims  = size(_data1,/dim)
		ndata = max([n_elements(_data1),n_elements(_data2),n_elements(_data3),n_elements(_data4),n_elements(_data5),n_elements(_data6),n_elements(_data7),n_elements(_data8),n_elements(_data9)])

		if var_set(_data1) then data1 = array(str(_data1),count=ndata) else data1 = replicate('',ndata)
		if var_set(_data2) then data2 = array(str(_data2),count=ndata) else data2 = replicate('',ndata)
		if var_set(_data3) then data3 = array(str(_data3),count=ndata) else data3 = replicate('',ndata)
		if var_set(_data4) then data4 = array(str(_data4),count=ndata) else data4 = replicate('',ndata)
		if var_set(_data5) then data5 = array(str(_data5),count=ndata) else data5 = replicate('',ndata)
		if var_set(_data6) then data6 = array(str(_data6),count=ndata) else data6 = replicate('',ndata)
		if var_set(_data7) then data7 = array(str(_data7),count=ndata) else data7 = replicate('',ndata)
		if var_set(_data8) then data8 = array(str(_data8),count=ndata) else data8 = replicate('',ndata)
		if var_set(_data9) then data9 = array(str(_data9),count=ndata) else data9 = replicate('',ndata)

		result = strarr(ndata)
		
		for idata=0L,ndata-1 do begin

			line = strjoin(strsplit(strjoin([strsplit(data1[idata],path_sep(),/extract),$
			       strsplit(data2[idata],path_sep(),/extract),strsplit(data3[idata],path_sep(),/extract),$
			       strsplit(data4[idata],path_sep(),/extract),strsplit(data5[idata],path_sep(),/extract),$																       
			       strsplit(data6[idata],path_sep(),/extract),strsplit(data7[idata],path_sep(),/extract),$
			       strsplit(data8[idata],path_sep(),/extract),strsplit(data9[idata],path_sep(),/extract)],path_sep()),path_sep(),/extract),path_sep())
																			 
			if strmid(str(data1[idata]),0,1) eq path_sep() then result[idata] = path_sep()+line else result[idata] = line

		endfor
		
		if size(_data1,/dim)+size(_data2,/dim)+size(_data3,/dim)+size(_data4,/dim)+size(_data5,/dim)+$
		   size(_data6,/dim)+size(_data7,/dim)+size(_data8,/dim)+size(_data9,/dim)eq 0 $
		   then return,result[0] else return,result
			 
		end			 

endcase

end
