;-------------------------------------------------------------------------------
;	NAME
;		ncdf_save
;
;	PURPOSE
;		To (quick) save data in ncdf format
;
;	USAGE
;		ncdf_save,file,data,name[,data2,name2,.....]
;
;	INPUT
;		file : file anme 
;		data : data array
;		name : variable name
;		gzip : If set, file is in ncdf4 format, and compressed
;
;	AUTHOR
;		2013-09-30 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	pro ncdf_save_var1,cdf_id,dd,var_name,ndim,gzip=gzip

;-------------------------------------------------------------------------------

dim = size(dd,/dim)
if ~var_set(ndim) then ndim = 0L

for idim=0L,n_elements(dim)-1 do dim_id = [idim eq 0 ? !null : dim_id,ncdf_dimdef(cdf_id,'dim'+str(ndim+idim+1),dim[idim])]

case size(dd,/tname) of
	
	'BYTE'    : var_id = ncdf_vardef(cdf_id,var_name,dim_id,/byte,gzip=gzip)
	'INT'     : var_id = ncdf_vardef(cdf_id,var_name,dim_id,/short,gzip=gzip)
	'LONG'    : var_id = ncdf_vardef(cdf_id,var_name,dim_id,/long,gzip=gzip)	
	'FLOAT'   : var_id = ncdf_vardef(cdf_id,var_name,dim_id,/float,gzip=gzip)
	'DOUBLE'  : var_id = ncdf_vardef(cdf_id,var_name,dim_id,/double,gzip=gzip)	
	'STRING'  : var_id = ncdf_vardef(cdf_id,var_name,dim_id,/string,gzip=gzip)	
	'UINT'    : var_id = ncdf_vardef(cdf_id,var_name,dim_id,/ushort,gzip=gzip)
	'ULONG'   : var_id = ncdf_vardef(cdf_id,var_name,dim_id,/ulong,gzip=gzip)
	'ULONG64' : var_id = ncdf_vardef(cdf_id,var_name,dim_id,/uint64,gzip=gzip)
	
	else : message,str(/join,'NOT DEFINED',size(dd,/tname))
		
endcase	

ndim += n_elements(dim_id)
end
;-------------------------------------------------------------------------------	

	pro ncdf_save,file,dd1,name1,dd2,name2,dd3,name3,dd4,name4,dd5,name5,$
	    dd6,name6,dd7,name7,dd8,name8,dd9,name9,dd10,name10,gzip=gzip,$
	    gatt=gatt
	    
	    
	
;-------------------------------------------------------------------------------	

cdf_id = ncdf_create(file,/clobber,netcdf4_format=keyword_set(gzip))

if var_set(dd1,name1) then ncdf_save_var1,cdf_id,dd1,name1,ndim,gzip=gzip
if var_set(dd2,name2) then ncdf_save_var1,cdf_id,dd2,name2,ndim,gzip=gzip
if var_set(dd3,name3) then ncdf_save_var1,cdf_id,dd3,name3,ndim,gzip=gzip
if var_set(dd4,name4) then ncdf_save_var1,cdf_id,dd4,name4,ndim,gzip=gzip
if var_set(dd5,name5) then ncdf_save_var1,cdf_id,dd5,name5,ndim,gzip=gzip
if var_set(dd6,name6) then ncdf_save_var1,cdf_id,dd6,name6,ndim,gzip=gzip
if var_set(dd7,name7) then ncdf_save_var1,cdf_id,dd7,name7,ndim,gzip=gzip
if var_set(dd8,name8) then ncdf_save_var1,cdf_id,dd8,name8,ndim,gzip=gzip
if var_set(dd9,name9) then ncdf_save_var1,cdf_id,dd9,name9,ndim,gzip=gzip
if var_set(dd10,name10) then ncdf_save_var1,cdf_id,dd10,name10,ndim,gzip=gzip

if var_set(gatt) then for i=0L,n_elements((tag=tag_names(gatt)))-1 do ncdf_attput,cdf_id,/global,tag[i],gatt.(i)

ncdf_control,cdf_id,/endef

if var_set(dd1,name1) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name1),dd1
if var_set(dd2,name2) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name2),dd2
if var_set(dd3,name3) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name3),dd3
if var_set(dd4,name4) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name4),dd4
if var_set(dd5,name5) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name5),dd5
if var_set(dd6,name6) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name6),dd6
if var_set(dd7,name7) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name7),dd7
if var_set(dd8,name8) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name8),dd8
if var_set(dd9,name9) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name9),dd9
if var_set(dd10,name10) then ncdf_varput,cdf_id,ncdf_varid(cdf_id,name10),dd10

ncdf_close,cdf_id

end
