;-------------------------------------------------------------------------------

	pro mir_wind,x,y,_ws,_wd,position=_p,component=component,cl=cl,_extra=_ex

;-------------------------------------------------------------------------------

opt = {p:var_set(_p,ina=[0,0,1,1]),npx:px2dev(17),npy:px2dev(17),base:px2dev(3),factor:1.,hsize:px2dev(5),color:mir_cl(/get,struct_read(_ex,'color',!p.color)),legend:1,barb:0}
clip = convert_coord(opt.p[[0,2]],opt.p[[1,3]],/normal,/to_device)
dim = size(reform(x),/dim)

case n_elements(dim) of

	1 : begin
		
		xy = chdmod(x,y,/data,/to_device)
		ws = _ws
		wd = _wd	
		end
	
	2 : begin
								
		dx = round((map_2points(((vv=chdmod(((p=opt.p))[[0,2]],p[[1,1]],/normal,/to_data)))[0],vv[1],vv[3],vv[4],/meters)/map_2points(x[0,0],y[0,0],x[1,0],y[0,0],/meters))/!d.x_size*(opt.p[2]-opt.p[0])*opt.npx)
		dy = round((map_2points(((vv=chdmod(((p=opt.p))[[0,0]],p[[1,3]],/normal,/to_data)))[0],vv[1],vv[3],vv[4],/meters)/map_2points(x[0,0],y[0,0],x[0,1],y[0,1],/meters))/!d.x_size*(opt.p[2]-opt.p[0])*opt.npx)	
		ws = _ws[0:*:dx,0:*:dy]
		wd = _wd[0:*:dx,0:*:dy]
		xy = chdmod(x[0:*:dx,0:*:dy],y[0:*:dx,0:*:dy],/data,/to_device)
		end

endcase

	; plot wind arrow or barb

if keyword_set(barb) then begin
				
	ws = keyword_set(component) ? cv_wind(ws,wd,/component_to_direction,owd=wd) : ws
						
	plot_wind_barb,ws/0.5147965,wd+180,xy[0,*],xy[1,*],noclip=0,color=color_load(/get,opt.color),_extra=_ex
	
endif else begin
		
	u = keyword_set(component) ? ws : cv_wind(ws,wd,/direction_to_component,ovwind=v)	
	v = keyword_set(component) ? wd : v
				
	arrow2,xy[0,*],xy[1,*],xy[0,*]+u*opt.base*opt.factor,xy[1,*]+v*opt.base*opt.factor,hsize=opt.hsize,noclip=0,color=color_load(/get,opt.color),resize=px2dev(5),_extra=_ex
		
endelse

	; legend
	
if keyword_set(opt.legend) then begin
	
	p = chdmod(opt.p[[0,1]],/normal,/to_device)+(dd=[0,-!d.y_ch_size/2.])	
	arrow2,p[0]+opt.base*opt.factor*(value=5),p[1],p[0],p[1],/device,hsize=opt.hsize,color=cl.black
	xyouts,p[0]+opt.base*opt.factor*value+!d.x_ch_size,p[1]+dd[1]*1.,/device,alignment=0,str(value)+' m/s',charsize=1

endif	

end
