;-------------------------------------------------------------------------------
;	NAME
;		mir_sp_include
;
;	PURPOSE
;		make additional plots inside mir_sp
;
;	USAGE
;		mir_sp_include
;
;	INPUT
;
;
;
;
;
;
;	AUTHOR
;		2014-09-30 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	pro mir_sp_note,dd,opt,cl=cl
	
;-------------------------------------------------------------------------------

	; title, tflag,timezone,unit
	
if struct_set(dd,'tflag') then xyouts,opt.p[0],opt.p[3]+px2dev(4.)/!d.y_vsize,str(/join,str(date(dd.tflag,/timezone,'UTC',(timezone=struct_read(dd,'timezone','UTC'))),/tflag_to_timestamp),timezone),/normal,color=cl.black,charsize=1.2
if struct_set(dd,'title') then xyouts,mean(opt.p[[0,2]]),opt.p[3]+px2dev(10.)/!d.y_vsize,str(dd.title),alignment=0.5,/normal,color=cl.black,charsize=1.7
if struct_set(dd,'unit')  then xyouts,opt.p[3]+px2dev(10)/!d.x_vsize,opt.p[0]-float(!d.y_ch_size)/!d.y_vsize*.2,/normal,alignment=1,'['+str(dd.unit,/title)+']',charsize=1
if struct_set(dd,'annotate') then xyouts,((pp=struct_read(dd,'pos',[0.2,0.8])))[0],pp[1],dd.annotate,/normal,charsize=struct_read(dd,'charsize',1.5),color=struct_read(dd,'color',cl.black)
if struct_set(dd,'text') then begin

	;print,'check'
	
	;text = dd.text
	
	;n = n_elements(text)
	
	;pp   = reform(ary(struct_read(dd,'pos',[0.02,0.015]),count=2*n),[2,n])
	
	;help,text,pp
	
	;charsize = ary(struct_read(dd,'charsize',1.),count=n)
	
	
	;for i=0L,n-1 do begin
	
	;	xyouts,pp[0,i],pp[1,i],text[i],/normal,charsize=charsize
		
	;endfor
	
	
	;for i=0L,n_elements(dd.text)-1 do begin

	xyouts,((pp=struct_read(dd,'pos',[0.02,0.015])))[0],pp[1],dd.text,/normal,charsize=struct_read(dd,'charsize',1.)
	
	;endfor
	
endif	

if struct_set(dd,'city') then begin

	name = dd.city
	ll   = dd.city_ll 	
	ll   = chdmod(ll[0,*],ll[1,*],/data,/to_dev)
	aa   = 10.
		
	for i=0L,n_elements(name)-1 do begin		
		
		;plots,ll[0,i]+aa,ll[1,i]-aa,/device,psym=7,symsize=1.5,color=cl.black
		;plots,ll[0,i],ll[1,i],/device,psym=7,symsize=1.5,color=cl.white		
		xyouts,ll[0,i]+aa,ll[1,i]-aa,name[i],/device,charsize=2,color=cl.black
		xyouts,ll[0,i],ll[1,i],name[i],/device,charsize=2,color=cl.white

	endfor
	
endif

end
;-------------------------------------------------------------------------------

	pro mir_sp_wind,_dd,_opt,cl=cl

;-------------------------------------------------------------------------------

case 1 of

	struct_set(_dd,'ws')    : mir_wind,_dd.lon,_dd.lat,_dd.ws,_dd.wd,position=_opt.p,cl=cl,thick=struct_read(_dd,'thick',0.3),color=struct_read(_dd,'color',!p.color)
	struct_set(_dd,'uwind') : mir_wind,_dd.lon,_dd.lat,_dd.uwind,_dd.vwind,position=_opt.p,/component,cl=cl,thick=struct_read(_dd,'thick',0.3),color=struct_read(_dd,'color',!p.color)
	struct_set(_dd,'uw')    : mir_wind,_dd.lon,_dd.lat,_dd.uw,_dd.vw,position=_opt.p,/component,cl=cl,thick=struct_read(_dd,'thick',0.3),color=struct_read(_dd,'color',!p.color)

endcase

end
;-------------------------------------------------------------------------------

	pro mir_sp_contour,dd,_opt,cl=cl,ct=ct
	
;-------------------------------------------------------------------------------

contour,dd.data,dd.lon,dd.lat,/overplot,$
	levels   = struct_read(dd,'c_levels',struct_set(ct,['xdiv','xdiv1','level']) ? ct.level[idx(ct.xdiv,ct.xdiv1,/point)] : struct_read(ct,'level')),$
	c_labels = ary(struct_read(dd,'c_labels',1B),count=n_elements(c_levels)),$
	c_colors = ary(color_load(/get,struct_read(dd,'c_colors',cl.dodgerblue)),count=n_elements(c_levels)),$
	c_thick  = struct_read(dd,'c_thick',1),$
	fill     = struct_read(dd,'fill',0)
	
end
;-------------------------------------------------------------------------------

	pro mir_sp_obs,_obs,_opt,cl=cl,ct=ct,ci=ci
	
;-------------------------------------------------------------------------------

ci  = mir_ci(data_check(_obs.data,finite(_obs.data) and _obs.data ne -999,oxx=xx),ct)
obs = {r:px2dev(4),charsize:0.8,bcolor:cl.black,lcolor:cl.black,llcolor:cl.slategray,format:str(ci.xdiv,/get_format),nolabel:1,thick:0.1}
obs = struct_merge(obs,_obs)

plot_circle,_obs.lon[xx],_obs.lat[xx],r_device=obs.r,/fill,$
	color    = ci.ind,$
	bcolor   = obs.bcolor eq -1 ? !null : obs.bcolor,$
	label    = str(str(round(obs.data),format=obs.format)),/auto,$
	charsize = obs.charsize,$
	lcolor   = obs.lcolor,$
	llcolor  = obs.llcolor,$
	nolabel  = obs.nolabel,$
	bthick   = obs.thick

end

;-------------------------------------------------------------------------------

	pro mir_sp_traj,opt

;-------------------------------------------------------------------------------

mir_traj,opt.tflag,1,lon=opt.lon,lat=opt.lat,file=struct_read(opt,'file'),minfo=struct_read(opt,'minfo')

end

;-------------------------------------------------------------------------------

	pro mir_sp_hys,opt

;-------------------------------------------------------------------------------

mir_hys,opt

end
;-------------------------------------------------------------------------------

	pro mir_sp_map,opt1,opt2,cl=cl
	
;-------------------------------------------------------------------------------

if struct_set(opt1,['file','minfo'])  then begin

	void = mir_map(file=opt1.file,minfo=opt1.minfo,color=struct_read(opt1,'color'),thick=struct_read(opt1,'thick'))

endif else begin
		
	void = mir_map(struct_read(opt1,'gadm'),minfo=opt2.minfo,color=mir_cl(/get,struct_read(opt1,'color')),thick=struct_read(opt1,'thick'))

endelse

end
;-------------------------------------------------------------------------------

	pro mir_sp_chart,opt
	
;-------------------------------------------------------------------------------

if ~struct_set(opt,'tflag') then return

mir_chart,opt.tflag,struct_read(opt,'data')

end
;-------------------------------------------------------------------------------

	pro mir_sp_line,opt,cl=cl
	
;-------------------------------------------------------------------------------

if struct_set(opt,['lon','lat']) then begin

	plots,opt.lon,opt.lat,color=mir_cl(/get,struct_read(opt,'color',!p.color)),thick=struct_read(opt,'thick',1.)

endif

end
;-------------------------------------------------------------------------------

	pro mir_sp_fill,opt1,opt2,cl=cl
	
;-------------------------------------------------------------------------------

if struct_set(opt1,['lon','lat']) then begin
		
	cc = mir_cl(/get,struct_read(opt1,'color','white'))
	aa = chdmod(opt1.lon,opt1.lat,/data,/to_device)
		
	if struct_read(opt1,'outside',0B) then begin
		
		bb = chdmod(opt2.limit[[1,3,5,7,1]],opt2.limit[[0,2,4,6,0]],/data,/to_device)	
		xx = [ary(aa[0,*],/flat),ary(bb[0,*],/flat)]
		yy = [ary(aa[1,*],/flat),ary(bb[1,*],/flat)]
		polyfill,xx,yy,color=cc,/device

	endif else begin
	
		polyfill,aa,color=cc,/device
	
	endelse
			
endif

end

;-------------------------------------------------------------------------------

	pro mir_sp_include,include,opt,cl=cl,ct=ct,ci=ci,ps_include=ps

;-------------------------------------------------------------------------------

if ~keyword_set(include) then return

for i=0L,n_elements(include)-1 do begin
		
	if ~keyword_set((type=struct_read(include[i],'type'))) then continue
	
	;if var_set(ps) and !d.name ne 'PS' then if idx(str(/low,ps),str(/low,type),/point) ne -1 then continue
	;if var_set(ps) and !d.name eq 'PS' then if idx(str(/low,ps),str(/low,type),/point) eq -1 then continue
				
	case str(/low,type) of
		
		'obs'     : mir_sp_obs,include[i],opt,cl=cl,ct=ct,ci=ci
		'wind'    : mir_sp_wind,include[i],opt,cl=cl
		'contour' : mir_sp_contour,include[i],opt,cl=cl,ct=ct
		'chart'   : mir_sp_chart,include[i]			
		'note'    : mir_sp_note,include[i],opt,cl=cl
		'traj'    : mir_sp_traj,include[i]
		'hys'     : mir_sp_hys,include[i]
		'map'     : mir_sp_map,include[i],opt,cl=cl
		'line'    : mir_sp_line,include[i]
		'fill'    : mir_sp_fill,include[i],opt,cl=cl
		
		else : 
				
	endcase
			
endfor

end
