;-------------------------------------------------------------------------------
;	NAME
;		mir_sp
;
;	PURPOSE
;		to plot spatial plot
;
;	USAGE
;		mir_sp,dd[,domain=,minfo=]
;
;	INPUT
;		missing:
;		limit:
;		position:
;		xsize:
;		ysize:
;		var:		
;		quality:
;		
;		loadct:
;		discrete:
;		range:
;
;
;	KEYWORD
;		hide : do not display
;	
;	AUTHOR
;		2014-07-21 Hyun Cheol Kim (hyun.kim@noaa.gov) rewritten from aqm_plot_tile.pro
;		2014-12-12 addded /contour
;-------------------------------------------------------------------------------

	pro mir_sp,_dd,domain=domain,minfo=minfo,lon=_lon,lat=_lat,map=map,cl=cl,ct=_ct,oinfo=oinfo,_extra=_ex
	
;-------------------------------------------------------------------------------

	; basic (error) case check

if var_set(_dd) then begin
	
	if size(reform(_dd),/n_dim) gt 2 then message,'DATA SHOULD BE 1-2 DIM'
	if ~var_set(domain,minfo,/if_any) then 	message,"DOMAIN/MINFO required to set a map projection (USAGE: mir_sp,dd,domain='5x'[,minfo=minfo])"
		
	dim = size((data=aryn(_dd,missing=struct_read(_ex,'missing',-999.))),/dim)
	ndata = n_elements(data)
	
endif
			
	; specify map limit

minfo = aqm_grid(domain=domain,minfo=minfo,olimit=limit1)
limit = mir_limit(struct_read(_ex,'limit',limit1),minfo=minfo)

	; plot size

opt = {p:struct_read(_ex,'position',[0.02,0.04,0.92,0.9]),winn:struct_read(_ex,'winn',0),hide:struct_read(_ex,'hide',0b),minfo:minfo,$
       ps:struct_read(_ex,'ps',0b)}

xyr = map_2points(limit[1],limit[0],limit[3],limit[2],/meters)/map_2points(limit[5],limit[4],limit[3],limit[2],/meters)

xsize = struct_read(_ex,'xsize',0b)
ysize = struct_read(_ex,'ysize',0b)
if ~keyword_set(xsize) and ~keyword_set(ysize) then if xyr lt 1 then xsize = 800 else ysize = 800
if ~keyword_set(xsize) then xsize = round((opt.p[3]-opt.p[1])/(opt.p[2]-opt.p[0])*ysize/xyr)
if ~keyword_set(ysize) then ysize = round((opt.p[2]-opt.p[0])/(opt.p[3]-opt.p[1])*xsize*xyr)

opt = struct_merge(opt,{xsize:struct_read(_ex,'xsize',xsize),ysize:struct_read(_ex,'ysize',ysize),limit:limit,xyr:xyr})

	; start z-buffer or ps
	
if ~opt.hide then if !d.window ne opt.winn then window,opt.winn,xsize=opt.xsize,ysize=opt.ysize

case (quality=struct_read(_ex,'quality',0)<3) of

	0 : plot_z,/open,xsize=opt.xsize,ysize=opt.ysize,d_name=d_name
	1 : plot_z,/open,xsize=opt.xsize,ysize=opt.ysize,d_name=d_name
	2 : plot_ps,(ps=file_name(struct_read(_ex,'png','test'),/png,/sdir)),/open,xsize=opt.xsize/100.,ysize=opt.ysize/100.,d_name=d_name
	else : plot_z,/open,xsize=opt.xsize,ysize=opt.ysize,d_name=d_name

endcase

	; color table set

cl = var_set(cl) ? cl : mir_cl()
;aa = mir_info(var=struct_read(_ex,'var'))
;if ~keyword_set(aa) and min(data,/nan) lt 0 and struct_set(_ex,['loadct','diff'],/if_any) ne 1 then aa = {loadct:70,diff:1,reverse_tbl:1}
ct = mir_ct(_ct,_extra=(xx=struct_read(_ex,['loadct','discrete','diff','reverse_tbl','ct_div','level','ndiv1','ndiv2'],/structure)))
ci = mir_ci(data,ct,_extra=(xx=struct_read(_ex,['range'],/structure)))

	; set map / rll / lcc		
				
case str(/low,minfo.proj) of	
	
	'll'  : begin
		limit[[0,2,4,6]] = [-75,-999,-999,-75] > limit[[0,2,4,6]] < [999,75,999,75]		
		lat0 = round(mean(limit[[0,2,4,6]])/30.)*30.
		lon0 = round(mean(limit[[1,3,5,7]])/30.)*30.		
		limit = limit[[0,1,4,5]]
		
		map_set,/merc,lat0,lon0,position=opt.p,/noerase,_extra=_ex,limit=limit				
		end
		
	'rll' : map_set,/merc,minfo.lat0,minfo.lon0,limit=opt.limit,position=opt.p,/noerase,_extra=_ex
	'ell' : map_set,/merc,mean(opt.limit[[0,2,4,6]]),mean(opt.limit[[1,3,5,7]]),limit=opt.limit,position=opt.p,/noerase,_extra=_ex	
	'lcc' : map_set,/conic,minfo.lat0,minfo.lon0,standard_parallels=[minfo.lat1,minfo.lat2],limit=opt.limit,position=opt.p,/noerase,_extra=_ex

endcase

	; background color

polyfill,[0,1,1,0,0],[0,0,1,1,0],/normal,color=struct_read(_ex,'bcolor',mir_cl(/get,'white'))
ci.ind = data_check(ci.ind,~finite(ci.ind),struct_read(_ex,'bcolor',mir_cl(/get,'gray')))

	; plots tiles
	
case 1 of

	struct_set(_ex,'contour') : begin
						
		if ~var_set(_lon) then xxx = aqm_grid(minfo=minfo,olon=c_lon,olat=c_lat) else c_lon = _lon
		if var_set(_lat) then c_lat = _lat 
																					
		contour,data,c_lon,c_lat,/overplot,$
			levels   = ary(ci.level,/uniq),$
			c_colors = ci.xdiv,$
			c_thick  = struct_read(_ex,'c_thick',1),$
			fill     = struct_read(_ex,'fill',1)
														
		if struct_set(_ex,'c_label') then contour,data,c_lon,c_lat,/overplot,$
			levels   = ary(ci.level[(xx = idx(ci.xdiv,ci.xdiv1,/point))],/uniq),$
			c_labels = replicate(1b,n_elements(xx)),$
			c_colors = cl.slategray,$
			c_thick  = struct_read(_ex,'c_thick',1)
									
		end
		
	var_set(data,_lon,_lat) : begin
				
		if ndata eq n_elements(_lon) then begin
		
			plot_circle,_lon,_lat,color=ci.ind,/fill
				
		endif else begin
					
			xxx = max(where(size(_lon,/dim) eq ndata))			
			lon = aryn(_lon,xxx+1,/backward)
			lat = aryn(_lat,xxx+1,/backward)
								
			for iv=0L,n_elements(ci.ind)-1 do begin
			
				polyfill,lon[*,iv],lat[*,iv],color=ci.ind[iv],/fill,/data
				
			endfor	
				
		endelse
		
		end		
		
	~array_equal(limit,limit1) : begin
			
		minfo = aqm_grid(domain=domain,minfo=minfo,otile=tile)	
		for iv=0L,minfo.nx*minfo.ny-1 do polyfill,tile.lon[*,iv],tile.lat[*,iv],color=ci.ind[iv],/fill,/data		
		end				
	
	else : begin
	
		
	
		if (!D.flags AND 1) NE 0 then begin
		
			pp = chdmod(limit1[[1,3,5,7]],limit1[[0,2,4,6]],/data,/to_normal)
			tv,ci.ind,pp[0,0],pp[1,0],xsize=(pp[0,2]-pp[0,0]),ysize=(pp[1,1]-pp[1,0]),/normal
		
		endif else begin
			
			pp = chdmod(limit1[[1,3,5,7]],limit1[[0,2,4,6]],/data,/to_device)									
			tv,congrid(ci.ind,pp[0,2]-pp[0,1],pp[1,1]-pp[1,0]),pp[0,0],pp[1,0],/device	
		
		endelse	
		end

endcase	
			
	; map again
		
case str(/low,minfo.proj) of
		
	'll'  : map_set,/merc,lat0,lon0,position=opt.p,/noerase,_extra=_ex,limit=limit,continent=~arg_present(map),/hires,usa=~arg_present(map),mlinethick=struct_read(_ex,'mlinethick',0.5)
	'rll' : map_set,/merc,minfo.lat0,minfo.lon0,limit=opt.limit,position=opt.p,/noerase,_extra=_ex,continent=~arg_present(map),/hires,usa=~arg_present(map),mlinethick=struct_read(_ex,'mlinethick',0.5)
	'ell' : map_set,/merc,mean(opt.limit[[0,2,4,6]]),mean(opt.limit[[1,3,5,7]]),limit=opt.limit,position=opt.p,/noerase,_extra=_ex	
	'lcc' : map_set,/conic,minfo.lat0,minfo.lon0,standard_parallels=[minfo.lat1,minfo.lat2],limit=opt.limit,position=opt.p,/noerase,_extra=_ex,continent=~arg_present(map),/hires,usa=~arg_present(map),mlinethick=struct_read(_ex,'mlinethick',0.5)

endcase

if arg_present(map) then map = mir_map(domain=domain,minfo=minfo,map=map)
			
	; map,colorbar, include and save

case quality of

	0 : begin
		
		mir_sp_include,struct_read(_ex,'include'),opt,cl=cl,ct=ct						
		
		cb = struct_read(_ex,'nocolorbar',0) ? 0 : mir_cb(ci,position=mir_p(/cb,opt.p,post=struct_read(_ex,'cb_post',1),max=350),$
			_extra=(xx=struct_read(_ex,['cb_charsize','unit'],/structure)))
			
		plot_z,/close,image=image,png=struct_read(_ex,'png'),d_name=d_name,hide=opt.hide,winn=opt.winn		
		end
		
	1 : begin
	
		mir_sp_include,struct_read(_ex,'include'),opt,cl=cl,ct=ct
				
		plot_z,/close,image=image,d_name=d_name		
		plot_ps,(ps=file_name(struct_read(_ex,'png','test'),/png,/sdir)),/open,xsize=opt.xsize/100.,ysize=opt.ysize/100.,d_name=d_name
		cl = mir_cl()				
		tv,image		
		
		mir_sp_include,struct_read(_ex,'further'),opt,cl=cl,ct=ct
			
		cb = struct_read(_ex,'nocolorbar',0) ? 0 : mir_cb(ci,position=mir_p(/cb,opt.p,post=struct_read(_ex,'cb_post',1),max=350),$
			_extra=(xx=struct_read(_ex,['cb_charsize','unit'],/structure)))
									
		plot_ps,ps,/close,/png,d_name=d_name,hide=opt.hide,winn=opt.winn,ps=struct_read(opt,'ps')
		end	
		
	2 : begin
							
		mir_sp_include,struct_read(_ex,'include'),opt,cl=cl,ct=ct
	
		cb = struct_read(_ex,'nocolorbar',0) ? 0 : mir_cb(ci,position=mir_p(/cb,opt.p,post=struct_read(_ex,'cb_post',1),max=350),$
			_extra=(xx=struct_read(_ex,['cb_charsize','unit'],/structure)))
			
		plot_ps,ps,/close,/png,d_name=d_name,hide=opt.hide,winn=opt.winn,ps=struct_read(opt,'ps')
		end	

endcase

oinfo = struct_make('ct',ct,'ci',ci,'cb',cb)

end
