;-------------------------------------------------------------------------------

	pro mir_hys,_opt,renew=renew,_extra=_ex
	
;-------------------------------------------------------------------------------

opt = _opt

aa = struct_set(opt,'file') ? opt.file : run_hysplit(opt.tflag,opt.nstep,opt.lon,opt.lat,opt.alt,renew=renew,_extra=_ex)
bb = rd_hys(aa,oinfo=bbi)
cc = mir_cl(ary(['red','blue','green','black','orange','slategray'],count=bbi.nalt),/get)
cc2 = mir_cl('gray',/get)

for i=0L,bbi.ndata-1 do begin
	
	plots,bb[i,*].lon,bb[i,*].lat,color=cc2,thick=6
	
endfor

for i=0L,bbi.ndata-1 do begin
	
	plots,bb[i,*].lon,bb[i,*].lat,color=cc[bbi.xalt[i]],thick=2
	
endfor

help,opt,/str

;pause

if struct_read(opt,'mark',0) then begin
	
	xx = where(bbi.tflag eq opt.mark,nxx)
	plot_circle,bb[*,xx].lon,bb[*,xx].lat,/fill,color=mir_cl(/get,'red'),bcolor=mir_cl(/get,'black'),r_device=px2dev(5)
	
endif else begin

	xx = indgen((bbi.ntime-1)/12.+1)*12
	plots,bb[*,xx].lon,bb[*,xx].lat,psym=7

endelse

line = str(/join,'HYS',bbi.tflag[0],'UTC')

p1 = 0.02
p2 = 0.02

xyouts,p1,p2,line,/normal,width=ww

for i=0L,bbi.nalt-1 do begin

	xyouts,(p1+=ww),p2,'  '+str(long(bbi.alt[i]))+'m',/normal,color=cc[i],width=ww
	
endfor	
	
end
