;-------------------------------------------------------------------------------
;	NAME
;		mir_ct
;
;	PURPOSE
;		to load color table
;
;	USAGE
;		ct = mir_ct(option[,_extra=])
;
;	INPUT
;		loadct : use loadct
;		ndiv1  : no. of major division
;		ndiv2  : no. of minor division
;		color  : colors (div)
;		scolor : starting color (div)
;		ecolor : ending color (div)
;		estep  : 
;		bottom : starting color index (default is 40)
;		top    : ending color index (default; !d.table_size; 256)
;
;	AUTHOR
;		2014-07-16 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function mir_ct_loadct,_n,_opt,_extra=_ex

;-------------------------------------------------------------------------------

opt    = struct_merge(_opt,_ex)
bottom = struct_read(opt,'bottom',40)
top    = struct_read(opt,'top',!d.table_size-1)
n      = var_set(_n,ina=11)
ndiv1  = struct_read(opt,'ndiv1',6)
ndiv2  = struct_read(opt,'ndiv2',4) 
ndiv2  = ary(ndiv2,count=ndiv1,/last)
xdiv1  = bottom+(top-bottom)*indgen(ndiv1+1)/ndiv1
xdiv2  = !null

for idiv1=0L,ndiv1-1 do begin

	if ndiv2[idiv1] le 1 then continue 
	
	xdiv2 = [xdiv2,(xdiv1[idiv1]+(xdiv1[idiv1+1]-xdiv1[idiv1])*indgen(ndiv2[idiv1]+1)/ndiv2[idiv1])[1:ndiv2[idiv1]-1]]	
		
endfor

s     = sort((xdiv=[xdiv1,xdiv2]))
xdiv  = xdiv[s]
xdiv_ = byte(min(xdiv)+(max(xdiv)-min(xdiv))*findgen(n_elements(xdiv))/(n_elements(xdiv)-1))
xdiv1 = xdiv_[idx(xdiv,xdiv1,/point)]
xdiv2 =  var_set(xdiv,xdiv2) ? xdiv_[idx(xdiv,xdiv2,/point)] : !null
xdiv  = xdiv_

	;

if !version.release lt '8.2.1' then begin

	color_tbl = path_check(path_check(getenv('HOME'),'data','mirie','tbl',/make),'colors1.tbl')
	if ~file_test(color_tbl) then run_scr,'wget --no-check-certificate -q https://www.dropbox.com/s/gtcdeqhvuydjqmd/colors1.tbl?dl=0 -O '+color_tbl

endif
						
loadct,n,bottom=bottom,rgb_table=tbl,ncolors=(top-bottom+1),file=color_tbl

tvlct,rr,gg,bb,/get

if struct_read(opt,'discrete',0) then begin

	xdiv3 = round((xdiv[1:*]-xdiv)/2.)+xdiv	
	r = tbl[xdiv3-bottom,0]
	g = tbl[xdiv3-bottom,1]
	b = tbl[xdiv3-bottom,2]
	
	rr[(ii=bottom+findgen(top-bottom+1))] = r[(xx=value_locate(xdiv,ii))]
	gg[ii] = g[xx]
	bb[ii] = b[xx]

endif else begin

	rr[bottom] = struct_set(opt,'reverse_tbl') ? reverse(tbl[*,0]) : tbl[*,0]
	gg[bottom] = struct_set(opt,'reverse_tbl') ? reverse(tbl[*,1]) : tbl[*,1]
	bb[bottom] = struct_set(opt,'reverse_tbl') ? reverse(tbl[*,2]) : tbl[*,2]

endelse

tvlct,rr,gg,bb

	;

opt = struct_merge(opt,struct_make('xdiv',xdiv,'xdiv1',xdiv1,'xdiv2',xdiv2))

return,opt

end
;-------------------------------------------------------------------------------

	function mir_ct_div,_opt,_extra=_ex

;-------------------------------------------------------------------------------

opt    = struct_merge(_opt,_ex)
bottom = struct_read(opt,'bottom',40)
top    = struct_read(opt,'top',!d.table_size-1)
color  = struct_read(opt,'color',['Lime Green','Yellow','Orange','Fire Brick','Purple','Maroon'])
ecolor = struct_read(opt,'ecolor','black')
ndiv1  = struct_read(opt,'ndiv1',n_elements(color))
ndiv2  = struct_read(opt,'ndiv2',4) 
color  = [ary(color,count=ndiv1),ecolor]
ndiv2  = ary(ndiv2,count=ndiv1,/last)
xdiv1  = bottom+(top-bottom)*indgen(ndiv1+1)/ndiv1
estep  = ary(struct_read(opt,'estep',0.7),count=ndiv1) < (ndiv2-1)/float(ndiv2)
tbl    = mir_cl(color,r1,g1,b1,/triple)
xdiv2  = (r2=(g2=(b2=!null)))

for idiv1=0L,ndiv1-1 do begin

	if ndiv2[idiv1] le 1 then continue 
	
	xdiv2 = [xdiv2,(xdiv1[idiv1]+(xdiv1[idiv1+1]-xdiv1[idiv1])*indgen(ndiv2[idiv1]+1)/ndiv2[idiv1])[1:ndiv2[idiv1]-1]]	
	
	f  = findgen(ndiv2[idiv1])/(ndiv2[idiv1]-1)*estep[idiv1]	
	r2 = [r2,((r1[idiv1+1]-r1[idiv1])*f+r1[idiv1])[1:*]]
	g2 = [g2,((g1[idiv1+1]-g1[idiv1])*f+g1[idiv1])[1:*]]
	b2 = [b2,((b1[idiv1+1]-b1[idiv1])*f+b1[idiv1])[1:*]]
		
endfor

s     = sort((xdiv=[xdiv1,xdiv2]))
xdiv  = xdiv[s]
r     = ([r1,r2])[s]
g     = ([g1,g2])[s]
b     = ([b1,b2])[s]
xdiv_ = byte(min(xdiv)+(max(xdiv)-min(xdiv))*findgen(n_elements(xdiv))/(n_elements(xdiv)-1))
xdiv1 = xdiv_[idx(xdiv,xdiv1,/point)]
xdiv2 =  var_set(xdiv,xdiv2) ? xdiv_[idx(xdiv,xdiv2,/point)] : !null
xdiv  = xdiv_

if struct_set(opt,'scolor') and ndiv2[0] ge 2 then begin

	xx = mir_cl(/triple,opt.scolor,r0,g0,b0)
	f = (findgen((n=fix(ndiv2[0]/2.+1)))/(n))[0:n-2]
	r[0:n-2] = (r[n]-r0)*f+r0
	g[0:n-2] = (g[n]-g0)*f+g0
	b[0:n-2] = (b[n]-b0)*f+b0

endif

xx = value_locate(xdiv[0:n_elements(div)-2],(ii=bottom+indgen(top-bottom+1)))

	; 

tvlct,rr,gg,bb,/get	

rr[ii] = r[xx]
gg[ii] = g[xx]
bb[ii] = b[xx]

tvlct,rr,gg,bb

opt = struct_merge(opt,struct_make('xdiv',xdiv,'xdiv1',xdiv1,'xdiv2',xdiv2))

return,opt
end
;-------------------------------------------------------------------------------

	function mir_ct,_opt,_extra=_ex

;-------------------------------------------------------------------------------

opt = struct_merge(_opt,_ex)

case 1 of

	struct_read(opt,'ct_div',0) : return,mir_ct_div(opt)
	struct_set(opt,'loadct') : return,mir_ct_loadct(opt.loadct,opt)
	struct_set(opt,'color')  : return,mir_ct_div(opt)
	struct_set(opt,'div')    : return,mir_ct_div(opt)
	
	else : return,mir_ct_loadct(20,opt)

endcase

end
