;-------------------------------------------------------------------------------
;	NAME
;		mir_cl
;
;	PURPOSE
;		to load color in color-table
;
;	USAGE
;		cl = mir_cl([pick][,/add,/get,/show][,rgb_table=arr])
;		
;		cl = mir_cl()                        load default colors
;		cl = mir_cl(['red','blue'])          load pick colors
;		cl = mir_cl(['tomato','gold'],/add)  load default+pick
;
;	INPUT
;		pick : list of colors;
;		bottom : start index
;		
;	KEYWORD
;		add : use default+pick colors
;		get : find closest index
;		show : show sample	
;
;	OUTPUT
;		tgb_table : return rgb table [*,3]	
;
;	AUTHOR
;		2014-07-15 Hyun Cheol Kim (hyun.kim@noaa.gov) rewritten from color_load.pro
;-------------------------------------------------------------------------------

	function mir_cl_list,lst

;-------------------------------------------------------------------------------

list = ['255 255 255 White',$
        '  0   0   0 Black',$
        '255 250 250 Snow',$
        '255 255 240 Ivory',$
        '255 255 224 Light Yellow',$
        '255 248 220 Cornsilk',$
        '245 245 220 Beige',$
        '255 245 238 Seashell',$
        '250 240 230 Linen',$
        '250 235 215 Antique White',$
        '255 239 213 Papaya',$
        '255 235 205 Almond',$
        '255 228 196 Bisque',$
        '255 228 181 Moccasin',$
        '245 222 179 Wheat',$
        '222 184 135 Burlywood',$
        '210 180 140 Tan',$
        '230 230 230 Light Gray',$
        '230 230 250 Lavender',$
        '210 210 210 Medium Gray',$
        '190 190 190 Gray',$
        '112 128 144 Slate Gray',$
        '110 110 110 Dark Gray',$
        ' 70  70  70 Charcoal',$
        '240 255 255 Honeydew',$
        '224 255 240 Light Cyan',$
        '176 224 230 Powder Blue',$
        '135 206 235 Sky Blue',$
        '100 149 237 Cornflower Blue',$
        ' 95 158 160 Cadet Blue',$
        ' 70 130 180 Steel Blue',$
        ' 30 144 255 Dodger Blue',$
        ' 65 105 225 Royal Blue',$
        '  0   0 255 Blue',$
        '  0   0 128 Navy',$
        '152 251 152 Pale Green',$
        '127 255 212 Aquamarine',$
        '  0 250 154 Spring Green',$
        '  0 255 255 Cyan',$
        ' 64 224 208 Turquoise',$
        '143 188 143 Light Sea Green',$
        ' 46 139  87 Sea Green',$
        ' 34 139  34 Forest Green',$
        '  0 128 128 Teal',$
        '173 255  47 Green Yellow',$
        '127 255   0 Chartreuse',$
        '124 252   0 Lawn Green',$
        '  0 255   0 Green',$
        ' 50 205  50 Lime Green',$
        '107 142  35 Olive Drab',$
        ' 85 107  47 Olive',$
        '  0 100   0 Dark Green',$
        '238 232 170 Pale Goldenrod',$
        '240 230 140 Khaki',$
        '189 183 107 Dark Khaki',$
        '255 255   0 Yellow',$
        '255 215   0 Gold',$
        '218 165  32 Goldenrod',$
        '184 134  11 Dark Goldenrod',$
        '139  69  19 Saddle Brown',$
        '255 228 225 Rose',$
        '255 192 203 Pink',$
        '188 143 143 Rosy Brown',$
        '244 164  96 Sandy Brown',$
        '205 133  63 Peru',$
        '205  92  92 Indian Red',$
        '210 105  30 Chocolate',$
        '160  82  45 Sienna',$
        '233 150 122 Dark Salmon',$
        '250 128 114 Salmon',$
        '255 160 122 Light Salmon',$
        '255 165   0 Orange',$
        '255 127  80 Coral',$
        '240 128 128 Light Coral',$
        '178  34  34 Firebrick',$
        '139   0   0 Dark Red',$
        '165  42  42 Brown',$
        '255 105 180 Hot Pink',$
        '255  20 147 Deep Pink',$
        '255   0 255 Magenta',$
        '255  99  71 Tomato',$
        '255  69   0 Orange Red',$
        '255   0   0 Red',$
        '220  20  60 Crimson',$
        '208  32 144 Violet Red',$
        '176  48  96 Maroon',$
        '216 191 216 Thistle',$
        '221 160 221 Plum',$
        '238 130 238 Violet',$
        '218 112 214 Orchid',$
        '186  85 211 Medium Orchid',$
        '153  50 204 Dark Orchid',$
        '138  43 226 Blue Violet',$
        '160  32 240 Purple',$
        '106  90 205 Slate Blue',$
        ' 72  61 139 Dark Slate Blue',$
        '255 255 255 WT1',$
        '255 250 250 WT2',$
        '255 255 240 WT3',$
        '255 255 224 WT4',$
        '255 248 220 WT5',$
        '245 245 220 WT6',$
        '255 245 238 WT7',$
        '250 240 230 WT8',$
        '250 235 215 TAN1',$
        '255 239 213 TAN2',$
        '255 235 205 TAN3',$
        '255 228 196 TAN4',$
        '255 228 181 TAN5',$
        '245 222 179 TAN6',$
        '222 184 135 TAN7',$
        '210 180 140 TAN8',$
        '250 250 250 BLK1',$
        '230 230 230 BLK2',$
        '210 210 210 BLK3',$
        '190 190 190 BLK4',$
        '128 128 128 BLK5',$
        '110 110 110 BLK6',$
        ' 70  70  70 BLK7',$
        '  0   0   0 BLK8',$
        '250 253 202 GRN1',$
        '223 242 167 GRN2',$
        '173 221 142 GRN3',$
        '109 193 115 GRN4',$
        ' 53 156  83 GRN5',$
        ' 35 132  67 GRN6',$
        '  0  97  52 GRN7',$
        '  0  69  41 GRN8',$
        '232 241 250 BLU1',$
        '202 222 240 BLU2',$
        '158 202 225 BLU3',$
        ' 99 168 211 BLU4',$
        ' 53 133 191 BLU5',$
        ' 33 113 181 BLU6',$
        '  8  75 147 BLU7',$
        '  8  48 107 BLU8',$
        '254 236 217 ORG1',$
        '253 212 171 ORG2',$
        '253 174 107 ORG3',$
        '250 134  52 ORG4',$
        '231  92  12 ORG5',$
        '217  72   1 ORG6',$
        '159  51   3 ORG7',$
        '127  39   4 ORG8',$
        '254 232 222 RED1',$
        '252 194 171 RED2',$
         '252 146 114 RED3',$
        '248  97  68 RED4',$
        '225  45  38 RED5',$
        '203  24  29 RED6',$
        '154  12  19 RED7',$
        '103   0  13 RED8',$
        '244 242 248 PUR1',$
        '222 221 237 PUR2',$
        '188 189 220 PUR3',$
        '152 148 197 PUR4',$
        '119 108 177 PUR5',$
        '106  82 163 PUR6',$
        ' 80  32 139 PUR7',$
        ' 63   0 125 PUR8',$
        '243 234 244 PBG1',$
        '213 212 232 PBG2',$
        '166 189 219 PBG3',$
        ' 94 164 204 PBG4',$
        ' 34 138 171 PBG5',$
        '  3 129 139 PBG6',$
        '  1 101  82 PBG7',$
        '  1  70  54 PBG8',$
        '244 250 193 YGB1',$
        '206 236 179 YGB2',$
        '127 205 186 YGB3',$
        ' 58 175 195 YGB4',$
        ' 30 125 182 YGB5',$
        ' 33  95 168 YGB6',$
        ' 32  48 137 YGB7',$
        '  8  29  88 YGB8',$
        '201  35  38 RYB1',$
        '245 121  72 RYB2',$
        '253 206 127 RYB3',$
        '251 253 197 RYB4',$
        '228 244 239 RYB5',$
        '193 228 239 RYB6',$
        '114 171 207 RYB7',$
        ' 59  85 164 RYB8',$
        ' 84  48   5 TG1',$
        '163 103  26 TG2',$
        '197 141  60 TG3',$
        '220 188 118 TG4',$
        '105 188 177 TG5',$
        ' 51 149 141 TG6',$
        ' 13 113 105 TG7',$
        '  0  81  71 TG8',$
        '  0   0 130 RS1',$
        '  0   0 178 RS2',$
        '  0   0 225 RS3',$
        '  0   0 254 RS4',$
        '110 106 254 RS5',$
        '202 201 254 RS6',$
        '242 212 212 RS7',$
        '224 121 117 RS8',$
        '217  40  17 RS9',$
        '191  16   0 RS10',$
        '151  13   0 RS11',$
        '113   9   0 RS12',$
	'255 255 255 MAPS1',$
	'182 246 255 MAPS2',$
	' 36 228 255 MAPS3',$
	' 25 255 190 MAPS4',$
	'164 255  84 MAPS5',$
	'255 222   0 MAPS6',$
	'255 128   0 MAPS7',$
	'255  34   0 MAPS8',$
	'195   0   0 MAPS9',$
	'102   0   0 MAPS10']
           
cl   = replicate(struct_make(['r','g','b'],0B,['name'],''),n_elements(list))
list = strmid(list,[0,4,8,12],[3,3,3,40])

cl.r = reform(byte(fix(list[0,*])))
cl.g = reform(byte(fix(list[1,*])))
cl.b = reform(byte(fix(list[2,*])))
cl.name = reform(strcompress(strlowcase(list[3,*]),/remove_all))

if var_set(lst) then cl = data_check(cl,(xx=idx(cl.name,strcompress(strlowcase(lst),/remove_all),/point)),/index)
if var_set(xx)  then if min(xx) eq -1 then message,str(/join,'Color NOT defined:',str(/join,del=',',lst[where(xx eq -1)]))

return,cl
end 

;-------------------------------------------------------------------------------

	function mir_cl_triple,_name,r,g,b

;-------------------------------------------------------------------------------

name = strcompress(strlowcase(_name),/remove_all)
list = mir_cl_list()
xx   = idx(list.name,name,/point)

if min(xx) eq -1 then message,str(/join,'Undefined:',name[where(xx eq -1)])

list = list[xx]
r    = float(list.r)
g    = float(list.g)
b    = float(list.b)

return,[[r],[g],[b]]
end
;-------------------------------------------------------------------------------

	function mir_cl,_pick,r,g,b,add=add,triple=triple,get=get,show=show,rgb_table=tbl,_extra=_ex

;-------------------------------------------------------------------------------

pick = ['White','Black','Red','Blue','Green','Yellow','Pink','Orange','Gray','Beige','Almond','Skyblue','Purple','Maroon','Violet','Lime Green', 'Honeydew','Slate Gray','Wheat','Tan','DodgerBlue']	
	
if var_set(_pick) then pick= keyword_set(add) ?  ary(strlowcase(strcompress([pick,_pick],/remove_all)),/uniq) : _pick
if struct_set(_ex,'full') then pick = (mir_cl_list()).name

	;

case 1 of

	keyword_set(show) : begin
	
		window,0,xsize=1024,ysize=768
			
		dxa = 0.1
		dya = 0.3		
		cl = mir_cl_list()
		cl = mir_cl((name=cl.name))								
		n  = n_elements(name)
		n2 = ceil(sqrt(n))
		p  = reform(pos(/multi,nx=n2,ny=n2,xa=dxa,ya=dya),[n2*n2,4])
				
		!p.background = cl.white
		!p.color      = cl.black
		
		plot,indgen(10),/nodata,color=cl.white
						
		for i=0L,n-1 do begin
		
			p2 = p[i,*]			
			polyfill,p2[[0,2,2,0,0]],p2[[1,1,3,3,1]],color=i,/normal				
			plots,p2[[0,2,2,0,0]],p2[[1,1,3,3,1]],color=cl.black,/normal								
			xyouts,(p2[0]+p2[2])/2.,p2[1]-0.012,name[i],/normal,alignment=0.5,charsize=1.

		endfor
		end

	keyword_set(get) : begin
	
		if size(_pick,/type) ne 7 then return,_pick
	
		tvlct,rr,gg,bb,/get
				
		cl = mir_cl_list(_pick)
		dd = intarr(n_elements(cl))
								
		for i=0L,n_elements(cl)-1 do begin
		
			xx = min((rr-cl[i].r)^2+(gg-cl[i].g)^2+(bb-cl[i].b)^2,imin)
			dd[i] = imin
		
		endfor
		
		return, n_elements(dd) eq 1 ? dd[0] : dd
		end
		
	keyword_set(triple) : return,mir_cl_triple(_pick,r,g,b)
			
	else : begin
								
		cl = mir_cl_list(pick)
				 
		tvlct,rr,gg,bb,/get
		
		rr[(xx=lindgen(n_elements(cl))+struct_read(_ex,'bottom',0L))] = cl.r
		gg[xx] = cl.g
		bb[xx] = cl.b
				
		tvlct,rr,gg,bb
		
		tbl = [[cl.r],[cl.g],[cl.b]]															
		cl  = struct_make(cl.name,xx,/extract)		
		
		!p.color = struct_read(cl,'black',0B)
		!p.background = struct_read(cl,'white',255B)
		
		return,cl
		end

endcase

end
