;-------------------------------------------------------------------------------
;	NAME
;		mir_ci
;
;	PURPOSE
;		to allocate color index for given data
;
;	USAGE
;		ci = mir_ci(data[,opt][,_extra=])
;
;	INPUT
;		range  : [min,max]
;		level  : data at xdiv
;		level1 : data at xdiv1 (if set, level2 is interpolated)
;
;	AUTHOR
;		2014-07-16 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function mir_ci,_dd,_opt,_extra=_ex

;-------------------------------------------------------------------------------

opt = {ndiv:6,xdiv_range:[40,!d.table_size-1]}
opt = struct_merge(struct_merge(opt,_opt),_ex)
dd = aqm_array(_dd,/nan)
mn = min(dd,/nan,max=mx)

xdiv  = struct_read(opt,'xdiv',byte(opt.xdiv_range[0]+(opt.xdiv_range[1]-opt.xdiv_range[0])*findgen(opt.ndiv+1)/opt.ndiv))
ndiv  = n_elements(xdiv)-1
range = struct_read(opt,'diff',0) ?  [-(mx=abs(mn)>abs(mx)),mx] : [mn,mx]
range = struct_read(_ex,'range',struct_read(opt,'range',range))

level = struct_set(opt,'level1') and struct_set(opt,'xdiv1') and struct_set(opt,'xdiv') $
	? interpol(ary(opt.level1,count=n_elements(opt.xdiv1),/last),opt.xdiv1,opt.xdiv) $
	: ary(struct_read(opt,'level',range[0]+(range[1]-range[0])*findgen(ndiv+1)/ndiv),count=(ndiv+1),/last)
ind   = reform(data_check(min(xdiv)>interpol(xdiv,level,dd)<max(xdiv),~finite(dd),!values.f_nan),size(_dd,/dim))

return,struct_merge(opt,struct_make('xdiv',xdiv,'ndiv',ndiv,'ind',ind,'level',level,'range',range))
end
