;-------------------------------------------------------------------------------
;	NAME
;		mir_chart
;
;	PURPOSE
;		To overplot weather chart
;
;	USAGE
;		mir_chart,tflag[,type]
;
;	INPUT
;		tflag : YYYYMMDDHH
;		type  : 'us' or 'kma'
;
;	AUTHOR
;		2014-04-09 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	pro mir_chart,tflag,type,_extra=_ex

;-------------------------------------------------------------------------------

if ~var_set(type) then begin
	
	lo = [-95,126]
	la = [ 37,37]
	ty = ['us','kma']
	ll = chdmod([0.5],[0.5],/normal,/to_data)	
	ss = sort((lo-ll[0])^2+(la-ll[1])^2)
	type = ty[ss[0]]

endif

case str(/low,type) of

	'us' : begin
	
		file = dn_wmap_usfntsfc(tflag)
		save = path_check(getenv('HOME'),'data','georef',str(/join,del='.','georef','wmap_usfntsfc','sav'))
		
		if ~file_test(file) then return
		if ~file_test(save) then run_scr,'wget --no-check-certificate -q https://www.dropbox.com/s/w8t5890tq1d3dvp/georef.wmap_usfntsfc.sav?dl=0 -O '+save
		
		restore,save

		color1 = ['red','red','blue','purple']
		color2 = ['gray','red','blue','purple']
		depth  = [40,5,5,5]
		rr = gif_extract_color(file,color1,depth,odim=dim)
					
		end
		
	'kma' : begin
	
		file = dn_wmap_kma(tflag)
		save = path_check(path_check(getenv('HOME'),'data','georef',/make),str(/join,del='.','georef','wmap_kmasfc3','sav'))
						
		if ~file_test(file) then return
		if ~file_test(save) then run_scr,'wget --no-check-certificate -q https://www.dropbox.com/s/c63xc88nbbd3hxg/georef.wmap_kmasfc3.sav?dl=0 -O '+save
				
		restore,save
		
		color1 = ['blue','red']
		color2 = color1
		depth  = [40,5]
		rr = gif_extract_color(file,color1,depth,odim=dim)
			
		end	

endcase

	;

psym    = struct_read(_ex,'psym',3)
symsize = struct_read(_ex,'symsize',1.)

for icolor=0L,n_elements(color1)-1 do begin

	plots,info.lon[where(rr[*,*,icolor])],info.lat[where(rr[*,*,icolor])],color=color_load(/get,color2[icolor]),noclip=0,psym=psym,symsize=symsize

endfor


end
