;-------------------------------------------------------------------------------
;	NAME
;		mir_cb
;
;	PURPOSE
;		To plot colorbar
;
;	USAGE
;		cb = mir_cb(opt[,_extra=])
;
;	INPUT
;		p/postion   : colorbar position
;		noline      :
;		nolabel     : 
;		label       : label (if not set, 
;		format      : label format
;		alignment   : 
;		orientation : 
;
;	AUTHOR
;		2014-07-16 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	pro mir_cb_label,opt,_dd,bar,line=_line,label=_label
	
;-------------------------------------------------------------------------------

if ~keyword_set((dd=struct_read(opt,_dd))) then return

if float(opt.p[2]-opt.p[0])/(opt.p[3]-opt.p[1]) ge 1 then begin

	x = (opt.p[0]+float(idx(bar[*,0],dd,/point))/n_elements(bar[*,0])*(opt.p[2]-opt.p[0]))*!d.x_vsize		
	y = opt.p[[1,3]]*!d.y_vsize

	if keyword_set(_line) then begin
	
		line = opt.line*!d.y_vsize*(opt.p[3]-opt.p[1])
		for i=0L,n_elements(x)-1 do if opt.p[2]-x[i]/!d.x_vsize ge 0.01 and x[i]/!d.x_vsize-opt.p[0] ge 0.01 then $
				plots,x[[i,i,i,i,i]],[y[0]+[0,line],!values.f_nan,y[1]+[0,-line]],/device,thick=0.5
					
	endif
	
	if keyword_set(_label) then begin
		
		label = ary(str(opt.label),count=n_elements(dd),/last)
		y     = y[[([0,0,1,1])[opt.post]]]+ !d.y_ch_size*([-1.2,0,0.5,0])[opt.post]								
		orien = struct_read(opt,'cb_orientation',max(strlen(label)) ge 4 ? 60 : 0)
		align = orien eq 0 ? 0.5 : ([1,1,0,0])[opt.post]
		
		for i=0L,n_elements(x)-1 do xyouts,x[i],y,label[i],/device,alignment=align,orientation=orien,charsize=struct_read(opt,'cb_charsize',1.)
	endif
									
endif else begin

	x = opt.p[[0,2]]*!d.x_vsize				
	y = (opt.p[1]+float(idx(bar[0,*],dd,/point))/n_elements(bar[0,*])*(opt.p[3]-opt.p[1]))*!d.y_vsize
			
	if keyword_set(_line) then begin
	
		line = opt.line*!d.x_vsize*(opt.p[2]-opt.p[0])
		
		for i=0L,n_elements(y)-1 do if opt.p[3]-y[i]/!d.y_vsize ge 0.01 and y[i]/!d.y_vsize-opt.p[1] ge 0.01 then $
				plots,[x[0]+[0,line],!values.f_nan,x[1]+[0,-line]],y[[i,i,i,i,i]],/device,thick=0.5
							
	endif	
	
	if keyword_set(_label) then begin
			
		label = ary(str(opt.label),count=n_elements(dd),/last)	
		x     = x[([1,1,0,0])[opt.post]]+(max(strlen(label))+1)*!d.x_ch_size*([0,1,0,-1])[opt.post]/2.
		y     = y + !d.y_ch_size/2.*([0,-1,0,-1])[opt.post]
						
		for i=0L,n_elements(y)-1 do xyouts,x,y[i],label[i],/device,alignment=0.5,charsize=struct_read(opt,'cb_charsize',1.)
	
	endif
											
endelse

end
;-------------------------------------------------------------------------------

	function mir_cb,_opt,_extra=_ex

;-------------------------------------------------------------------------------

if struct_read(_ex,'nocolorbar') eq 1 then return,!null

opt = {p:struct_read(_ex,'position',[0.1,0.05,0.9,0.08]),xdiv_range:[0,!d.table_size-1],scalable:(!D.flags AND 1) NE 0,post:-1}
opt = struct_merge(struct_merge(opt,_opt),_ex)

if opt.post eq -1 then opt.post = float(opt.p[2]-opt.p[0])/(opt.p[3]-opt.p[1]) ge 1 ? (mean(opt.p[[1,3]]) le 0.5 ? 0 : 2) : (mean(opt.p[[0,2]]) ge 0.5 ? 1 : 3)

bar = (opt.p[2]-opt.p[0]) ge (opt.p[3]-opt.p[1]) ? bindgen(!d.table_size) # replicate(1B,20) : replicate(1B,20) # bindgen(!d.table_size)
bar = bytscl(bar,top=(!d.table_size-1 < (opt.xdiv_range[1]-opt.xdiv_range[0]))) + opt.xdiv_range[0]	

if opt.scalable $
	then tv,bar,opt.p[0],opt.p[1],xsize=(opt.p[2]-opt.p[0]),ysize=(opt.p[3]-opt.p[1]),/normal $
	else tv,(bar=congrid(bar,ceil((opt.p[2]-opt.p[0])*!d.x_vsize),ceil((opt.p[3]-opt.p[1])*!d.y_vsize),/interp)),opt.p[0],opt.p[1],/normal

noline  = ary(struct_read(opt,'noline',0B),count=2)
nolabel = ary(struct_read(opt,'nolabel',0B),count=2)
nobox   = struct_read(opt,'nobox',0B)

label = struct_read(opt,'level',struct_read(opt,'xdiv',0B))
if keyword_set(label) then label = struct_set(opt,'format') ? str(label,format=opt.format) : str(label,/auto_format)
if keyword_set(label) then label = struct_read(opt,'label',label)

case 1 of

	array_equal(noline,[1,0]) : mir_cb_label,struct_merge(opt,{line:0.1}),'xdiv2',bar,/line
	array_equal(noline,[0,1]) : mir_cb_label,struct_merge(opt,{line:0.5}),'xdiv1',bar,/line
	array_equal(noline,[1,1]) :
	else : begin
		
		mir_cb_label,struct_merge(opt,{line:0.1}),'xdiv2',bar,/line
		mir_cb_label,struct_merge(opt,{line:0.5}),'xdiv1',bar,/line
		end

endcase

case 1 of

	array_equal(nolabel,[1,0]) : if keyword_set(label) and struct_set(opt,'xdiv') and struct_set(opt,'xdiv2') then mir_cb_label,struct_merge(opt,{label:label[idx(opt.xdiv,opt.xdiv2,/point)]}),'xdiv2',bar,/label
	array_equal(nolabel,[0,1]) : if keyword_set(label) and struct_set(opt,'xdiv') and struct_set(opt,'xdiv1') then mir_cb_label,struct_merge(opt,{label:label[idx(opt.xdiv,opt.xdiv1,/point)]}),'xdiv1',bar,/label
	array_equal(nolabel,[1,1]) : 
	else : if keyword_set(label) then mir_cb_label,struct_merge(opt,{label:label}),'xdiv',bar,/label
	
endcase

if ~keyword_set(nobox) then plots,opt.p[[0,2,2,0,0]],opt.p[[1,1,3,3,1]],color=struct_read(_ex,'color',!p.color),/normal,thick=0.5

if struct_set(opt,'unit') then if opt.post mod 2 eq 1 then $
	xyouts,(opt.p[2]-opt.p[0])/2.+opt.p[0],opt.p[1]-0.02,'['+str(opt.unit)+']',/normal,alignment=0.5 else $	
	xyouts,opt.p[2]+0.01,opt.p[1],'['+str(opt.unit)+']',/normal
						
return,opt
end
